/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.bean.DexClass;
import net.dongliu.apk.parser.bean.Icon;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.ApkMetaTranslator;
import net.dongliu.apk.parser.parser.BinaryXmlParser;
import net.dongliu.apk.parser.parser.CertificateParser;
import net.dongliu.apk.parser.parser.CompositeXmlStreamer;
import net.dongliu.apk.parser.parser.DexParser;
import net.dongliu.apk.parser.parser.ResourceTableParser;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.parser.XmlTranslator;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.utils.Utils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

public class ApkParser
implements Closeable {
    private DexClass[] dexClasses;
    private ResourceTable resourceTable;
    private String manifestXml;
    private ApkMeta apkMeta;
    private Set<Locale> locales;
    private List<CertificateMeta> certificateMetaList;
    private final ZipFile zf;
    private File apkFile;
    private static final Locale defaultLocale = Locale.US;
    private Locale preferredLocale = defaultLocale;

    public ApkParser(File apkFile) throws IOException {
        this.apkFile = apkFile;
        this.zf = new ZipFile(apkFile);
    }

    public ApkParser(String filePath) throws IOException {
        this(new File(filePath));
    }

    public String getManifestXml() throws IOException {
        if (this.manifestXml == null) {
            this.parseManifestXml();
        }
        return this.manifestXml;
    }

    public ApkMeta getApkMeta() throws IOException {
        if (this.apkMeta == null) {
            this.parseApkMeta();
        }
        return this.apkMeta;
    }

    public Set<Locale> getLocales() throws IOException {
        if (this.locales == null) {
            this.parseResourceTable();
        }
        return this.locales;
    }

    public List<CertificateMeta> getCertificateMetaList() throws IOException, CertificateException {
        if (this.certificateMetaList == null) {
            this.parseCertificate();
        }
        return this.certificateMetaList;
    }

    private void parseCertificate() throws IOException, CertificateException {
        ZipArchiveEntry entry = null;
        Enumeration enu = this.zf.getEntries();
        while (enu.hasMoreElements()) {
            ZipArchiveEntry ne = (ZipArchiveEntry)enu.nextElement();
            if (ne.isDirectory() || !ne.getName().toUpperCase().endsWith(".RSA") && !ne.getName().toUpperCase().endsWith(".DSA")) continue;
            entry = ne;
            break;
        }
        if (entry == null) {
            throw new ParserException("ApkParser certificate not found");
        }
        try (InputStream in = this.zf.getInputStream(entry);){
            CertificateParser parser = new CertificateParser(in);
            parser.parse();
            this.certificateMetaList = parser.getCertificateMetas();
        }
    }

    private void parseApkMeta() throws IOException {
        if (this.manifestXml == null) {
            this.parseManifestXml();
        }
    }

    private void parseManifestXml() throws IOException {
        XmlTranslator xmlTranslator = new XmlTranslator();
        ApkMetaTranslator translator = new ApkMetaTranslator();
        CompositeXmlStreamer xmlStreamer = new CompositeXmlStreamer(xmlTranslator, translator);
        this.transBinaryXml("AndroidManifest.xml", xmlStreamer);
        this.manifestXml = xmlTranslator.getXml();
        if (this.manifestXml == null) {
            throw new ParserException("manifest xml not exists");
        }
        this.apkMeta = translator.getApkMeta();
    }

    public String transBinaryXml(String path) throws IOException {
        ZipArchiveEntry entry = Utils.getEntry(this.zf, path);
        if (entry == null) {
            return null;
        }
        if (this.resourceTable == null) {
            this.parseResourceTable();
        }
        XmlTranslator xmlTranslator = new XmlTranslator();
        this.transBinaryXml(path, xmlTranslator);
        return xmlTranslator.getXml();
    }

    public Icon getIconFile() throws IOException {
        ApkMeta apkMeta = this.getApkMeta();
        String iconPath = apkMeta.getIcon();
        if (iconPath == null) {
            return null;
        }
        return new Icon(iconPath, this.getFileData(iconPath));
    }

    private void transBinaryXml(String path, XmlStreamer xmlStreamer) throws IOException {
        ZipArchiveEntry entry = Utils.getEntry(this.zf, path);
        if (entry == null) {
            return;
        }
        if (this.resourceTable == null) {
            this.parseResourceTable();
        }
        InputStream in = this.zf.getInputStream(entry);
        ByteBuffer buffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)in));
        BinaryXmlParser binaryXmlParser = new BinaryXmlParser(buffer, this.resourceTable);
        binaryXmlParser.setLocale(this.preferredLocale);
        binaryXmlParser.setXmlStreamer(xmlStreamer);
        binaryXmlParser.parse();
    }

    public DexClass[] getDexClasses() throws IOException {
        if (this.dexClasses == null) {
            this.parseDexFile();
        }
        return this.dexClasses;
    }

    private void parseDexFile() throws IOException {
        ZipArchiveEntry resourceEntry = Utils.getEntry(this.zf, "classes.dex");
        if (resourceEntry == null) {
            throw new ParserException("Resource table not found");
        }
        InputStream in = this.zf.getInputStream(resourceEntry);
        ByteBuffer buffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)in));
        DexParser dexParser = new DexParser(buffer);
        dexParser.parse();
        this.dexClasses = dexParser.getDexClasses();
    }

    public byte[] getFileData(String path) throws IOException {
        ZipArchiveEntry entry = Utils.getEntry(this.zf, path);
        if (entry == null) {
            return null;
        }
        InputStream inputStream = this.zf.getInputStream(entry);
        return IOUtils.toByteArray((InputStream)inputStream);
    }

    public ApkSignStatus verifyApk() throws IOException {
        ZipArchiveEntry entry = Utils.getEntry(this.zf, "META-INF/MANIFEST.MF");
        if (entry == null) {
            return ApkSignStatus.notSigned;
        }
        JarFile jarFile = new JarFile(this.apkFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        byte[] buffer = new byte[8192];
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            if (e.isDirectory()) continue;
            try {
                InputStream in = jarFile.getInputStream(e);
                Throwable throwable = null;
                try {
                    int count;
                    while ((count = in.read(buffer, 0, buffer.length)) != -1) {
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (SecurityException se) {
                return ApkSignStatus.incorrect;
            }
        }
        return ApkSignStatus.signed;
    }

    private void parseResourceTable() throws IOException {
        ZipArchiveEntry entry = Utils.getEntry(this.zf, "resources.arsc");
        if (entry == null) {
            this.resourceTable = new ResourceTable();
            this.locales = Collections.emptySet();
            return;
        }
        this.resourceTable = new ResourceTable();
        this.locales = Collections.emptySet();
        InputStream in = this.zf.getInputStream(entry);
        ByteBuffer buffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)in));
        ResourceTableParser resourceTableParser = new ResourceTableParser(buffer);
        resourceTableParser.parse();
        this.resourceTable = resourceTableParser.getResourceTable();
        this.locales = resourceTableParser.getLocales();
    }

    @Override
    public void close() throws IOException {
        this.certificateMetaList = null;
        this.resourceTable = null;
        this.certificateMetaList = null;
        this.zf.close();
    }

    public Locale getPreferredLocale() {
        return this.preferredLocale;
    }

    public void setPreferredLocale(Locale preferredLocale) {
        if (!Objects.equals(this.preferredLocale, preferredLocale)) {
            this.preferredLocale = preferredLocale;
            this.manifestXml = null;
            this.apkMeta = null;
        }
    }
}

