/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.bean;

import java.util.ArrayList;
import java.util.List;

public class Constants {

    public static enum InstallLocation {
        auto(0),
        internalOnly(1),
        preferExternal(2);

        private int value;

        private InstallLocation(int value) {
            this.value = value;
        }

        public static InstallLocation valueOf(int value) {
            for (InstallLocation installLocation : InstallLocation.values()) {
                if (installLocation.value != value) continue;
                return installLocation;
            }
            return null;
        }
    }

    public static enum ProtectionLevel {
        normal(0),
        dangerous(1),
        signature(2),
        signatureOrSystem(3),
        system(16),
        development(32);

        private int value;

        private ProtectionLevel(int value) {
            this.value = value;
        }

        public static List<ProtectionLevel> valueOf(int value) {
            ArrayList<ProtectionLevel> list = new ArrayList<ProtectionLevel>();
            if ((value & ProtectionLevel.system.value) != 0) {
                value ^= ProtectionLevel.system.value;
                list.add(system);
            }
            if ((value & ProtectionLevel.development.value) != 0) {
                value ^= ProtectionLevel.development.value;
                list.add(development);
            }
            for (ProtectionLevel protectionLevel : ProtectionLevel.values()) {
                if (protectionLevel.value != value) continue;
                list.add(protectionLevel);
            }
            return list;
        }
    }

    public static enum WindowSoftInputMode {
        adjustNothing(48),
        adjustPan(32),
        adjustResize(16),
        adjustUnspecified(0),
        stateAlwaysHidden(3),
        stateAlwaysVisible(5),
        stateHidden(2),
        stateUnchanged(1),
        stateUnspecified(0),
        stateVisible(4);

        private static int mask_adjust;
        private static int mask_state;
        private int value;

        private WindowSoftInputMode(int value) {
            this.value = value;
        }

        public static List<WindowSoftInputMode> valuesOf(int value) {
            ArrayList<WindowSoftInputMode> list = new ArrayList<WindowSoftInputMode>(2);
            for (WindowSoftInputMode w : WindowSoftInputMode.values()) {
                if (w.value == (value & mask_adjust) && w.toString().startsWith("adjust")) {
                    list.add(w);
                }
                if (w.value != (value & mask_state) || !w.toString().startsWith("state")) continue;
                list.add(w);
            }
            return list;
        }

        static {
            mask_adjust = 240;
            mask_state = 15;
        }
    }

    public static enum ConfigChanges {
        density(4096),
        fontScale(0x40000000),
        keyboard(16),
        keyboardHidden(32),
        direction(8192),
        locale(4),
        mcc(1),
        mnc(2),
        navigation(64),
        orientation(128),
        screenLayout(256),
        screenSize(1024),
        smallestScreenSize(2048),
        touchscreen(8),
        uiMode(512);

        private int value;

        private ConfigChanges(int value) {
            this.value = value;
        }

        public static List<ConfigChanges> valuesOf(int value) {
            ArrayList<ConfigChanges> list = new ArrayList<ConfigChanges>();
            for (ConfigChanges c : ConfigChanges.values()) {
                if ((c.value & value) == 0) continue;
                list.add(c);
            }
            return list;
        }
    }

    public static enum LaunchMode {
        standard(0),
        singleTop(1),
        singleTask(2),
        singleInstance(3);

        private int value;

        private LaunchMode(int value) {
            this.value = value;
        }

        public static LaunchMode valueOf(int value) {
            for (LaunchMode s : LaunchMode.values()) {
                if (s.value != value) continue;
                return s;
            }
            return null;
        }
    }

    public static enum ScreenOrientation {
        behind(3),
        fullSensor(10),
        fullUser(13),
        landscape(0),
        locked(14),
        nosensor(5),
        portrait(1),
        reverseLandscape(8),
        reversePortrait(9),
        sensor(4),
        sensorLandscape(6),
        sensorPortrait(7),
        unspecified(-1),
        user(2),
        userLandscape(11),
        userPortrait(12);

        private int value;

        private ScreenOrientation(int value) {
            this.value = value;
        }

        public static ScreenOrientation valueOf(int value) {
            for (ScreenOrientation s : ScreenOrientation.values()) {
                if (s.value != value) continue;
                return s;
            }
            return null;
        }
    }
}

