/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import net.dongliu.apk.parser.bean.Activity;
import net.dongliu.apk.parser.bean.AndroidComponent;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.GlEsVersion;
import net.dongliu.apk.parser.bean.IntentFilter;
import net.dongliu.apk.parser.bean.Permission;
import net.dongliu.apk.parser.bean.Receiver;
import net.dongliu.apk.parser.bean.Service;
import net.dongliu.apk.parser.bean.UseFeature;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.struct.xml.Attributes;
import net.dongliu.apk.parser.struct.xml.XmlCData;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceStartTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeStartTag;

public class ApkMetaTranslator
implements XmlStreamer {
    private String[] tagStack = new String[100];
    private int depth = 0;
    private ApkMeta apkMeta = new ApkMeta();
    private IntentFilter intentFilter;
    private AndroidComponent component;

    @Override
    public void onStartTag(XmlNodeStartTag xmlNodeStartTag) {
        Attributes attributes = xmlNodeStartTag.getAttributes();
        switch (xmlNodeStartTag.getName()) {
            case "application": {
                this.apkMeta.setLabel(attributes.get("label"));
                this.apkMeta.setIcon(attributes.get("icon"));
                break;
            }
            case "manifest": {
                this.apkMeta.setPackageName(attributes.get("package"));
                this.apkMeta.setVersionName(attributes.get("versionName"));
                this.apkMeta.setVersionCode(attributes.getLong("versionCode"));
                String installLocation = attributes.get("installLocation");
                if (installLocation == null) break;
                this.apkMeta.setInstallLocation(installLocation);
                break;
            }
            case "uses-sdk": {
                this.apkMeta.setMinSdkVersion(attributes.get("minSdkVersion"));
                this.apkMeta.setTargetSdkVersion(attributes.get("targetSdkVersion"));
                this.apkMeta.setMaxSdkVersion(attributes.get("maxSdkVersion"));
                break;
            }
            case "supports-screens": {
                this.apkMeta.setAnyDensity(attributes.getBoolean("anyDensity", false));
                this.apkMeta.setSmallScreens(attributes.getBoolean("smallScreens", false));
                this.apkMeta.setNormalScreens(attributes.getBoolean("normalScreens", false));
                this.apkMeta.setLargeScreens(attributes.getBoolean("largeScreens", false));
                break;
            }
            case "uses-feature": {
                String name = attributes.get("name");
                boolean required = attributes.getBoolean("required", false);
                if (name != null) {
                    UseFeature useFeature = new UseFeature();
                    useFeature.setName(name);
                    useFeature.setRequired(required);
                    this.apkMeta.addUseFeatures(useFeature);
                    break;
                }
                Integer gl = attributes.getInt("glEsVersion");
                if (gl == null) break;
                int v = gl;
                GlEsVersion glEsVersion = new GlEsVersion();
                glEsVersion.setMajor(v >> 16);
                glEsVersion.setMinor(v & 0xFFFF);
                glEsVersion.setRequired(required);
                this.apkMeta.setGlEsVersion(glEsVersion);
                break;
            }
            case "uses-permission": {
                this.apkMeta.addUsesPermission(attributes.get("name"));
                break;
            }
            case "permission": {
                Permission permission = new Permission();
                permission.setName(attributes.get("name"));
                permission.setLabel(attributes.get("label"));
                permission.setIcon(attributes.get("icon"));
                permission.setGroup(attributes.get("group"));
                permission.setDescription(attributes.get("description"));
                String protectionLevel = attributes.get("android:protectionLevel");
                if (protectionLevel != null) {
                    permission.setProtectionLevel(protectionLevel);
                }
                this.apkMeta.addPermission(permission);
                break;
            }
            case "service": {
                Service service = new Service();
                this.fillComponent(attributes, service);
                this.component = service;
                break;
            }
            case "activity-alias": 
            case "activity": {
                Activity activity = new Activity();
                this.fillComponent(attributes, activity);
                this.component = activity;
                break;
            }
            case "receiver": {
                Receiver receiver = new Receiver();
                this.fillComponent(attributes, receiver);
                this.component = receiver;
                break;
            }
            case "intent-filter": {
                if (!this.matchLastTag("activity") && !this.matchLastTag("receiver") && !this.matchLastTag("service") && !this.matchLastTag("activity-alias")) break;
                this.intentFilter = new IntentFilter();
                break;
            }
            case "action": {
                if (!this.matchLastTag("intent-filter")) break;
                this.intentFilter.addAction(attributes.get("name"));
                break;
            }
            case "category": {
                if (!this.matchLastTag("intent-filter")) break;
                this.intentFilter.addCategory(attributes.get("name"));
                break;
            }
            case "data": {
                if (!this.matchLastTag("intent-filter")) break;
                String scheme = attributes.get("scheme");
                String host = attributes.get("host");
                String pathPrefix = attributes.get("pathPrefix");
                String mimeType = attributes.get("mimeType");
                String type = attributes.get("type");
                IntentFilter.IntentData data = new IntentFilter.IntentData();
                data.setScheme(scheme);
                data.setMimeType(mimeType);
                data.setHost(host);
                data.setPathPrefix(pathPrefix);
                data.setType(type);
                this.intentFilter.addData(data);
            }
        }
        this.tagStack[this.depth++] = xmlNodeStartTag.getName();
    }

    private void fillComponent(Attributes attributes, AndroidComponent component) {
        component.setName(attributes.get("name"));
        component.setExported(attributes.getBoolean("exported", false));
        component.setProcess(attributes.get("process"));
    }

    @Override
    public void onEndTag(XmlNodeEndTag xmlNodeEndTag) {
        --this.depth;
        switch (xmlNodeEndTag.getName()) {
            case "service": {
                this.apkMeta.addService((Service)this.component);
                this.component = null;
                break;
            }
            case "activity": {
                this.apkMeta.addActivity((Activity)this.component);
                this.component = null;
                break;
            }
            case "receiver": {
                this.apkMeta.addReceiver((Receiver)this.component);
                this.component = null;
                break;
            }
            case "intent-filter": {
                if (!this.matchLastTag("activity") && !this.matchLastTag("receiver") && !this.matchLastTag("service") && !this.matchLastTag("activity-alias")) break;
                this.apkMeta.addIntentFilter(this.intentFilter);
                this.component.addIntentFilter(this.intentFilter);
                this.intentFilter = null;
            }
        }
    }

    @Override
    public void onCData(XmlCData xmlCData) {
    }

    @Override
    public void onNamespaceStart(XmlNamespaceStartTag tag) {
    }

    @Override
    public void onNamespaceEnd(XmlNamespaceEndTag tag) {
    }

    public ApkMeta getApkMeta() {
        return this.apkMeta;
    }

    private boolean matchTagPath(String ... tags) {
        if (this.depth != tags.length + 1) {
            return false;
        }
        for (int i = 1; i < this.depth; ++i) {
            if (this.tagStack[i].equals(tags[i - 1])) continue;
            return false;
        }
        return true;
    }

    private boolean matchLastTag(String tag) {
        return this.tagStack[this.depth - 1].endsWith(tag);
    }
}

