/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        try {
            byte[] byArray;
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int len;
                while ((len = in.read(buf)) != -1) {
                    bos.write(buf, 0, len);
                }
                byArray = bos.toByteArray();
            }
            catch (Throwable throwable) {
                bos.close();
                throw throwable;
            }
            bos.close();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static String toString(InputStream in) throws IOException {
        return new String(Utils.toByteArray(in), "UTF-8");
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        return new String(Utils.toByteArray(in), encoding);
    }

    public static long toLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static int toInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String between(String text, String begin, String end) {
        if (text == null) {
            return null;
        }
        int idx = text.indexOf(begin);
        idx = idx < 0 ? 0 : (idx += begin.length());
        int eidx = text.indexOf(end, idx);
        if (eidx < 0) {
            eidx = 0;
        }
        return text.substring(idx, eidx);
    }

    public static ZipArchiveEntry getEntry(ZipFile zf, String path) {
        Enumeration enu = zf.getEntries();
        while (enu.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)enu.nextElement();
            if (entry.isDirectory() || !entry.getName().equals(path)) continue;
            return entry;
        }
        return null;
    }
}

