package net.dongliu.commons;

import net.dongliu.commons.collection.ExList;
import net.dongliu.commons.collection.ExMap;
import net.dongliu.commons.collection.ExSet;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Utils methods for all object
 *
 * @author Liu Dong {@literal <im@dongliu.net>}
 */
public class ObjectUtils {

    /**
     * If value is null, return defaultValue; else return value
     */
    public static <T> T nonNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    /**
     * If value is null, return "", else return value
     */
    public static String nonNull(String value) {
        return value == null ? "" : value;
    }

    /**
     * If list is null, return new mutable empty list; else list it's self
     */
    public static <T> List<T> nonNull(List<T> list) {
        return list == null ? ExList.of() : list;
    }

    /**
     * If set is null, return new mutable empty set; else set it's self
     */
    public static <T> Set<T> nonNull(Set<T> set) {
        return set == null ? ExSet.of() : set;
    }

    /**
     * If map is null, return new mutable empty map; else map it's self
     */
    public static <K, V> Map<K, V> nonNull(Map<K, V> map) {
        return map == null ? ExMap.of() : map;
    }

    /**
     * Safe unbox, return false if value is null
     */
    public static boolean unbox(Boolean value) {
        return value == null ? false : value;
    }

    /**
     * Safe unbox, return '0' if value is null
     */
    public static char unbox(Character value) {
        return value == null ? '0' : value;
    }

    /**
     * Safe unbox, return 0 if value is null
     */
    public static byte unbox(Byte value) {
        return value == null ? 0 : value;
    }

    /**
     * Safe unbox, return 0 if value is null
     */
    public static short unbox(Short value) {
        return value == null ? 0 : value;
    }

    /**
     * Safe unbox, return 0 if value is null
     */
    public static int unbox(Integer value) {
        return value == null ? 0 : value;
    }

    /**
     * Safe unbox, return 0 if value is null
     */
    public static long unbox(Long value) {
        return value == null ? 0 : value;
    }

    /**
     * Safe unbox, return 0 if value is null
     */
    public static float unbox(Float value) {
        return value == null ? 0 : value;
    }

    /**
     * Safe unbox, return 0 if value is null
     */
    public static double unbox(Double value) {
        return value == null ? 0 : value;
    }
}
