package net.dongliu.commons;

import java.util.Arrays;

/**
 * Utils method for print
 *
 * @author Liu Dong {@literal <im@dongliu.net>}
 */
public class Printer {

    /**
     * Print value
     */
    public static void print(Object value) {
        System.out.print(toString(value));
    }

    /**
     * Print line
     */
    public static void println() {
        System.out.println();
    }

    /**
     * Prints an Object and then terminate the line.
     */
    public static void println(Object value) {
        System.out.println(toString(value));
    }

    /**
     * Format print using the specified format string and arguments.
     */
    public static void printf(String format, Object... values) {
        System.out.printf(format, values);
    }

    private static String toString(Object value) {
        if (ReflectUtils.isArray(value)) {
            Class<?> cls = value.getClass();
            String str;
            if (cls == byte[].class)
                str = Arrays.toString((byte[]) value);
            else if (cls == short[].class)
                str = Arrays.toString((short[]) value);
            else if (cls == int[].class)
                str = Arrays.toString((int[]) value);
            else if (cls == long[].class)
                str = Arrays.toString((long[]) value);
            else if (cls == char[].class)
                str = Arrays.toString((char[]) value);
            else if (cls == float[].class)
                str = Arrays.toString((float[]) value);
            else if (cls == double[].class)
                str = Arrays.toString((double[]) value);
            else if (cls == boolean[].class)
                str = Arrays.toString((boolean[]) value);
            else
                str = Arrays.deepToString((Object[]) value);
            return str;
        } else {
            return String.valueOf(value);
        }
    }
}
