package net.dongliu.commons;

import java.lang.reflect.Field;

/**
 * Utils method for reflect
 *
 * @author Liu Dong {@literal <im@dongliu.net>}
 */
public class ReflectUtils {

    /**
     * If cls is a primitive class
     */
    public static boolean isPrimitive(Class cls) {
        return cls == boolean.class || cls == char.class
                || cls == int.class || cls == byte.class || cls == short.class || cls == long.class
                || cls == float.class || cls == double.class;
    }

    /**
     * If obj is array. Return true if obj is not null and is array, otherwise false.
     */
    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    private static Field getObjectField(Object o, String name) {
        Field field;
        try {
            field = o.getClass().getDeclaredField(name);
        } catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        field.setAccessible(true);
        return field;
    }

    /**
     * Get field's value.
     */
    public static <T> T getField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return (T) field.get(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static boolean getBooleanField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return field.getBoolean(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static int getIntField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return field.getInt(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static long getLongField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return field.getLong(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static float getFloatField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return field.getFloat(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static double getDoubleField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return field.getDouble(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * Get field's value.
     */
    public static byte getByteField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return field.getByte(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static short getShortField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return field.getShort(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static char getCharField(Object o, String name) {
        Field field = getObjectField(o, name);
        try {
            return field.getChar(o);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setField(Object o, String name, Object value) {
        Field field = getObjectField(o, name);
        try {
            field.set(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * Set field's value.
     */
    public static void setBooleanField(Object o, String name, boolean value) {
        Field field = getObjectField(o, name);
        try {
            field.setBoolean(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setIntField(Object o, String name, int value) {
        Field field = getObjectField(o, name);
        try {
            field.setInt(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setLongField(Object o, String name, long value) {
        Field field = getObjectField(o, name);
        try {
            field.setLong(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setFloatField(Object o, String name, float value) {
        Field field = getObjectField(o, name);
        try {
            field.setFloat(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setDoubleField(Object o, String name, double value) {
        Field field = getObjectField(o, name);
        try {
            field.setDouble(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * Set field's value.
     */
    public static void setByteField(Object o, String name, byte value) {
        Field field = getObjectField(o, name);
        try {
            field.setByte(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setShortField(Object o, String name, short value) {
        Field field = getObjectField(o, name);
        try {
            field.setShort(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setCharField(Object o, String name, char value) {
        Field field = getObjectField(o, name);
        try {
            field.setChar(o, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static <T> T getStaticField(Class cls, String name) {
        Field field = getClassField(cls, name);
        try {
            return (T) field.get(null);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getClassField(Class cls, String name) {
        Field field;
        try {
            field = cls.getDeclaredField(name);
            field.setAccessible(true);
        } catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return field;
    }

    /**
     * Get field's value.
     */
    public static int getStaticIntField(Class cls, String name) {
        Field field = getClassField(cls, name);
        try {
            return field.getInt(null);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static long getStaticLongField(Class cls, String name) {
        Field field = getClassField(cls, name);
        try {
            return field.getLong(null);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static float getStaticFloatField(Class cls, String name) {
        Field field = getClassField(cls, name);
        try {
            return field.getFloat(null);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static double getStaticDoubleField(Class cls, String name) {
        Field field = getClassField(cls, name);
        try {
            return field.getDouble(null);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * Get field's value.
     */
    public static byte getStaticByteField(Class cls, String name) {
        Field field = getClassField(cls, name);
        try {
            return field.getByte(null);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static short getStaticShortField(Class cls, String name) {
        Field field = getClassField(cls, name);
        try {
            return field.getShort(null);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get field's value.
     */
    public static char getStaticCharField(Class cls, String name) {
        Field field = getClassField(cls, name);
        try {
            return field.getChar(null);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setStaticField(Class cls, String name, Object value) {
        Field field = getClassField(cls, name);
        try {
            field.set(null, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setStaticIntField(Class cls, String name, int value) {
        Field field = getClassField(cls, name);
        try {
            field.setInt(null, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setStaticLongField(Class cls, String name, long value) {
        Field field = getClassField(cls, name);
        try {
            field.setLong(null, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setStaticFloatField(Class cls, String name, float value) {
        Field field = getClassField(cls, name);
        try {
            field.setFloat(null, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setStaticDoubleField(Class cls, String name, double value) {
        Field field = getClassField(cls, name);
        try {
            field.setDouble(null, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * Set field's value.
     */
    public static void setStaticByteField(Class cls, String name, byte value) {
        Field field = getClassField(cls, name);
        try {
            field.setByte(null, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setStaticShortField(Class cls, String name, short value) {
        Field field = getClassField(cls, name);
        try {
            field.setShort(null, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Set field's value.
     */
    public static void setStaticCharField(Class cls, String name, char value) {
        Field field = getClassField(cls, name);
        try {
            field.setChar(null, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

}
