package net.dongliu.commons.collection;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Expanded ArrayList
 *
 * @author Liu Dong
 */
public class ExArrayList<T> extends ArrayList<T> implements ExList<T> {
    private static final long serialVersionUID = 5814709254840746807L;

    public ExArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public ExArrayList() {
    }

    public ExArrayList(Collection<? extends T> c) {
        super(c);
    }

    /**
     * Create mutable list
     */
    public static <T> ExArrayList<T> of() {
        return new ExArrayList<>();
    }

    /**
     * Create mutable list
     */
    public static <T> ExArrayList<T> of(T value) {
        ExArrayList<T> list = new ExArrayList<>();
        list.add(value);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExArrayList<T> of(T value1, T value2) {
        ExArrayList<T> list = new ExArrayList<>();
        list.add(value1);
        list.add(value2);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExArrayList<T> of(T value1, T value2, T value3) {
        ExArrayList<T> list = new ExArrayList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExArrayList<T> of(T value1, T value2, T value3, T value4) {
        ExArrayList<T> list = new ExArrayList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExArrayList<T> of(T value1, T value2, T value3, T value4, T value5) {
        ExArrayList<T> list = new ExArrayList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExArrayList<T> of(T value1, T value2, T value3, T value4, T value5,
                                              T value6) {
        ExArrayList<T> list = new ExArrayList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExArrayList<T> of(T value1, T value2, T value3, T value4, T value5,
                                              T value6, T value7) {
        ExArrayList<T> list = new ExArrayList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        list.add(value7);
        return list;
    }

    @SafeVarargs
    public static <T> ExArrayList<T> of(T... values) {
        ExArrayList<T> list = new ExArrayList<>(values.length);
        list.addAll(values);
        return list;
    }

    @Override
    public ExList<T> subList(int fromIndex, int toIndex) {
        return ExList.wrap(super.subList(fromIndex, toIndex));
    }

}
