package net.dongliu.commons.collection;

import java.util.function.*;
import java.util.stream.DoubleStream;

/**
 * Expanded double stream
 *
 * @author Liu Dong
 */
public interface ExDoubleStream extends DoubleStream {

    static ExDoubleStream of(DoubleStream stream) {
        if (stream instanceof ExDoubleStream) {
            return (ExDoubleStream) stream;
        }
        return new ForwardingDoubleStream(stream);
    }

    @Override
    ExDoubleStream filter(DoublePredicate predicate);

    @Override
    ExDoubleStream map(DoubleUnaryOperator mapper);

    @Override
    <U> ExStream<U> mapToObj(DoubleFunction<? extends U> mapper);

    @Override
    ExIntStream mapToInt(DoubleToIntFunction mapper);

    @Override
    ExLongStream mapToLong(DoubleToLongFunction mapper);

    @Override
    ExDoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper);

    @Override
    ExDoubleStream distinct();

    @Override
    ExDoubleStream sorted();

    @Override
    ExDoubleStream peek(DoubleConsumer action);

    @Override
    ExDoubleStream limit(long maxSize);

    @Override
    ExDoubleStream skip(long n);

    @Override
    ExStream<Double> boxed();

    @Override
    ExDoubleStream sequential();

    @Override
    ExDoubleStream parallel();

    @Override
    ExDoubleStream unordered();

    @Override
    ExDoubleStream onClose(Runnable closeHandler);

}
