package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * Expanded hash map
 *
 * @author Liu Dong
 */
public class ExHashMap<K, V> extends HashMap<K, V> implements ExMap<K, V> {
    private static final long serialVersionUID = 5987932063950184578L;

    public ExHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ExHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ExHashMap() {
    }

    public ExHashMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    /**
     * Create mutable empty map
     */
    public static <K, V> ExHashMap<K, V> of() {
        return new ExHashMap<>();
    }

    /**
     * Create mutable map
     */
    @SafeVarargs
    public static <K, V> ExHashMap<K, V> of(Pair<K, V>... pairs) {
        ExHashMap<K, V> map = new ExHashMap<>();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    /**
     * Create mutable map
     */
    public static <K, V> ExHashMap<K, V> of(Collection<Pair<K, V>> pairs) {
        ExHashMap<K, V> map = new ExHashMap<>();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }


    /**
     * create mutable map
     */
    public static <K, V> ExHashMap<K, V> of(K key, V value) {
        ExHashMap<K, V> map = new ExHashMap<>();
        map.put(key, value);
        return map;
    }

    /**
     * create mutable map
     */
    public static <K, V> ExHashMap<K, V> of(K key1, V value1,
                                            K key2, V value2) {
        ExHashMap<K, V> map = new ExHashMap<>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    /**
     * create mutable map
     */
    public static <K, V> ExHashMap<K, V> of(K key1, V value1,
                                            K key2, V value2,
                                            K key3, V value3) {
        ExHashMap<K, V> map = new ExHashMap<>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    /**
     * create mutable map
     */
    public static <K, V> ExHashMap<K, V> of(K key1, V value1,
                                            K key2, V value2,
                                            K key3, V value3,
                                            K key4, V value4) {
        ExHashMap<K, V> map = new ExHashMap<>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        return map;
    }

    /**
     * create mutable map
     */
    public static <K, V> ExHashMap<K, V> of(K key1, V value1,
                                            K key2, V value2,
                                            K key3, V value3,
                                            K key4, V value4,
                                            K key5, V value5) {
        ExHashMap<K, V> map = new ExHashMap<>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        return map;
    }

    /**
     * create mutable map
     */
    public static <K, V> ExHashMap<K, V> of(K key1, V value1,
                                            K key2, V value2,
                                            K key3, V value3,
                                            K key4, V value4,
                                            K key5, V value5,
                                            K key6, V value6) {
        ExHashMap<K, V> map = new ExHashMap<>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        return map;
    }

    /**
     * create mutable map
     */
    public static <K, V> ExHashMap<K, V> of(K key1, V value1,
                                            K key2, V value2,
                                            K key3, V value3,
                                            K key4, V value4,
                                            K key5, V value5,
                                            K key6, V value6,
                                            K key7, V value7) {
        ExHashMap<K, V> map = new ExHashMap<>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        return map;
    }
}
