package net.dongliu.commons.collection;

import java.util.function.*;
import java.util.stream.IntStream;

/**
 * Expanded int stream
 *
 * @author Liu Dong
 */
public interface ExIntStream extends IntStream {

    static ExIntStream of(IntStream stream) {
        if (stream instanceof ExIntStream) {
            return (ExIntStream) stream;
        } else {
            return new ForwardingIntStream(stream);
        }
    }

    @Override
    ExIntStream filter(IntPredicate predicate);

    @Override
    ExIntStream map(IntUnaryOperator mapper);

    @Override
    <U> ExStream<U> mapToObj(IntFunction<? extends U> mapper);

    @Override
    ExLongStream mapToLong(IntToLongFunction mapper);

    @Override
    ExDoubleStream mapToDouble(IntToDoubleFunction mapper);

    @Override
    ExIntStream flatMap(IntFunction<? extends IntStream> mapper);

    @Override
    ExIntStream distinct();

    @Override
    ExIntStream sorted();

    @Override
    ExIntStream peek(IntConsumer action);

    @Override
    ExIntStream limit(long maxSize);

    @Override
    ExIntStream skip(long n);

    @Override
    ExLongStream asLongStream();

    @Override
    ExDoubleStream asDoubleStream();

    @Override
    ExStream<Integer> boxed();

    @Override
    ExIntStream sequential();

    @Override
    ExIntStream parallel();

    @Override
    ExIntStream unordered();

    @Override
    ExIntStream onClose(Runnable closeHandler);
}

