package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.LinkedHashSet;

/**
 * Expanded linked hash set
 *
 * @author Liu Dong
 */
public class ExLinkedHashSet<T> extends LinkedHashSet<T> implements ExSet<T> {
    private static final long serialVersionUID = -3575142697097689727L;

    public ExLinkedHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ExLinkedHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public ExLinkedHashSet() {
    }

    public ExLinkedHashSet(Collection<T> c) {
        super(c);
    }


    /**
     * Create mutable set
     */
    public static <T> ExLinkedHashSet<T> of() {
        return new ExLinkedHashSet<>();
    }

    /**
     * Create mutable set
     */
    public static <T> ExLinkedHashSet<T> of(T value) {
        ExLinkedHashSet<T> list = new ExLinkedHashSet<>();
        list.add(value);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExLinkedHashSet<T> of(T value1, T value2) {
        ExLinkedHashSet<T> list = new ExLinkedHashSet<>();
        list.add(value1);
        list.add(value2);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExLinkedHashSet<T> of(T value1, T value2, T value3) {
        ExLinkedHashSet<T> list = new ExLinkedHashSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExLinkedHashSet<T> of(T value1, T value2, T value3, T value4) {
        ExLinkedHashSet<T> list = new ExLinkedHashSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExLinkedHashSet<T> of(T value1, T value2, T value3, T value4, T value5) {
        ExLinkedHashSet<T> list = new ExLinkedHashSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExLinkedHashSet<T> of(T value1, T value2, T value3, T value4, T value5,
                                              T value6) {
        ExLinkedHashSet<T> list = new ExLinkedHashSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExLinkedHashSet<T> of(T value1, T value2, T value3, T value4, T value5,
                                              T value6, T value7) {
        ExLinkedHashSet<T> list = new ExLinkedHashSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        list.add(value7);
        return list;
    }

    @SafeVarargs
    public static <T> ExLinkedHashSet<T> of(T... values) {
        ExLinkedHashSet<T> list = new ExLinkedHashSet<>();
        list.addAll(values);
        return list;
    }
}
