package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.LinkedList;

/**
 * Expanded linked list
 *
 * @author Liu Dong
 */
public class ExLinkedList<T> extends LinkedList<T> implements ExList<T> {
    private static final long serialVersionUID = -296474324601260821L;

    public ExLinkedList() {
    }

    public ExLinkedList(Collection<? extends T> c) {
        super(c);
    }


    /**
     * Create mutable list
     */
    public static <T> ExLinkedList<T> of(T value) {
        ExLinkedList<T> list = new ExLinkedList<>();
        list.add(value);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExLinkedList<T> of(T value1, T value2) {
        ExLinkedList<T> list = new ExLinkedList<>();
        list.add(value1);
        list.add(value2);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExLinkedList<T> of(T value1, T value2, T value3) {
        ExLinkedList<T> list = new ExLinkedList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExLinkedList<T> of(T value1, T value2, T value3, T value4) {
        ExLinkedList<T> list = new ExLinkedList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExLinkedList<T> of(T value1, T value2, T value3, T value4, T value5) {
        ExLinkedList<T> list = new ExLinkedList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExLinkedList<T> of(T value1, T value2, T value3, T value4, T value5,
                                              T value6) {
        ExLinkedList<T> list = new ExLinkedList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        return list;
    }

    /**
     * Create mutable list
     */
    public static <T> ExLinkedList<T> of(T value1, T value2, T value3, T value4, T value5,
                                              T value6, T value7) {
        ExLinkedList<T> list = new ExLinkedList<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        list.add(value7);
        return list;
    }
    
    @SafeVarargs
    public static <T> ExLinkedList<T> of(T... values) {
        ExLinkedList<T> list = new ExLinkedList<>();
        list.addAll(values);
        return list;
    }

    @Override
    public ExList<T> subList(int fromIndex, int toIndex) {
        return ExList.wrap(super.subList(fromIndex, toIndex));
    }
}
