package net.dongliu.commons.collection;

import java.util.Collections;
import java.util.List;

/**
 * Expanded list
 *
 * @author Liu Dong
 */
public interface ExList<T> extends List<T>, ExCollection<T> {
    @Override
    ExList<T> subList(int fromIndex, int toIndex);

    /**
     * If list is not EnhancedList, wrap list to EnhancedList.
     */
    static <T> ExList<T> wrap(List<T> list) {
        if (list instanceof ExList) {
            return (ExList<T>) list;
        }
        return new ForwardingList<>(list);
    }

    /**
     * Create immutable view of this List.
     */
    default List<T> immutable() {
        return Collections.unmodifiableList(this);
    }

    /**
     * Create mutable list
     */
    static <T> ExList<T> of() {
        return ExArrayList.of();
    }

    /**
     * Create mutable list
     */
    static <T> ExList<T> of(T value) {
        return ExArrayList.of(value);
    }

    /**
     * Create mutable list
     */
    static <T> ExList<T> of(T value1, T value2) {
        return ExArrayList.of(value1, value2);
    }

    /**
     * Create mutable list
     */
    static <T> ExList<T> of(T value1, T value2, T value3) {
        return ExArrayList.of(value1, value2, value3);
    }

    /**
     * Create mutable list
     */
    static <T> ExList<T> of(T value1, T value2, T value3, T value4) {
        return ExArrayList.of(value1, value2, value3, value4);
    }

    /**
     * Create mutable list
     */
    static <T> ExList<T> of(T value1, T value2, T value3, T value4, T value5) {
        return ExArrayList.of(value1, value2, value3, value4, value5);
    }

    /**
     * Create mutable list
     */
    static <T> ExList<T> of(T value1, T value2, T value3, T value4, T value5, T value6) {
        return ExArrayList.of(value1, value2, value3, value4, value5, value6);
    }

    /**
     * Create mutable list
     */
    static <T> ExList<T> of(T value1, T value2, T value3, T value4, T value5, T value6,
                                 T value7) {
        return ExArrayList.of(value1, value2, value3, value4, value5, value6, value7);
    }

    /**
     * create mutable list
     */
    @SafeVarargs
    static <T> ExList<T> of(T... values) {
        return ExArrayList.of(values);
    }
}
