package net.dongliu.commons.collection;

import java.util.function.*;
import java.util.stream.LongStream;

/**
 * Expanded long stream
 *
 * @author Liu Dong
 */
public interface ExLongStream extends LongStream {

    static ExLongStream of(LongStream stream) {
        if (stream instanceof ExLongStream) {
            return (ExLongStream) stream;
        }
        return new ForwardingLongStream(stream);
    }

    @Override
    ExLongStream filter(LongPredicate predicate);

    @Override
    ExLongStream map(LongUnaryOperator mapper);

    @Override
    <U> ExStream<U> mapToObj(LongFunction<? extends U> mapper);

    @Override
    ExIntStream mapToInt(LongToIntFunction mapper);

    @Override
    ExDoubleStream mapToDouble(LongToDoubleFunction mapper);

    @Override
    ExLongStream flatMap(LongFunction<? extends LongStream> mapper);

    @Override
    ExLongStream distinct();

    @Override
    ExLongStream sorted();

    @Override
    ExLongStream peek(LongConsumer action);

    @Override
    ExLongStream limit(long maxSize);

    @Override
    ExLongStream skip(long n);

    @Override
    ExDoubleStream asDoubleStream();

    @Override
    ExStream<Long> boxed();

    @Override
    ExLongStream sequential();

    @Override
    ExLongStream parallel();

    @Override
    ExLongStream unordered();

    @Override
    ExLongStream onClose(Runnable closeHandler);

}
