package net.dongliu.commons.collection;

import net.dongliu.commons.ObjectUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/**
 * Expanded map
 *
 * @author Liu Dong
 */
public interface ExMap<K, V> extends Map<K, V> {

    /**
     * If map is not EnhancedMap, wrap to EnhancedMap
     */
    static <K, V> ExMap<K, V> wrap(Map<K, V> map) {
        if (map instanceof ExMap) {
            return (ExMap<K, V>) map;
        }
        return new ForwardingMap<>(map);
    }

    /**
     * Key set result as stream
     */
    default ExStream<K> keyStream() {
        return ExStream.wrap(keySet().stream());
    }

    /**
     * Value collection result as stream
     */
    default ExStream<V> valueStream() {
        return ExStream.wrap(values().stream());
    }

    /**
     * EntrySet result as stream
     */
    default ExStream<Entry<K, V>> entryStream() {
        return ExStream.wrap(entrySet().stream());
    }

    /**
     * Create immutable view of this Set.
     */
    default Map<K, V> immutable() {
        return Collections.unmodifiableMap(this);
    }

    /**
     * Get value with key from this map, if not exists, or value is null, return defaultValue
     */
    default V getNonNull(K key, V defaultValue) {
        return ObjectUtils.nonNull(get(key), defaultValue);
    }

    /**
     * Create mutable empty map
     */
    static <K, V> ExMap<K, V> of() {
        return ExHashMap.of();
    }

    /**
     * Create mutable map
     */
    @SafeVarargs
    static <K, V> ExMap<K, V> of(Pair<K, V>... pairs) {
        return ExHashMap.of(pairs);
    }

    /**
     * Create mutable map
     */
    static <K, V> ExHashMap<K, V> of(Collection<Pair<K, V>> pairs) {
        return ExHashMap.of(pairs);
    }

    /**
     * create mutable map
     */
    static <K, V> ExMap<K, V> of(K key, V value) {
        return ExHashMap.of(key, value);
    }

    /**
     * create mutable map
     */
    static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2) {
        return ExHashMap.of(key1, value1, key2, value2);
    }

    /**
     * create mutable map
     */
    static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2,
                                 K key3, V value3) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3);
    }

    /**
     * create mutable map
     */
    static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2,
                                 K key3, V value3, K key4, V value4) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    /**
     * create mutable map
     */
    static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2,
                                 K key3, V value3, K key4, V value4,
                                 K key5, V value5) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3, key4, value4,
                key5, value5);
    }

    /**
     * create mutable map
     */
    static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2,
                                 K key3, V value3, K key4, V value4,
                                 K key5, V value5, K key6, V value6) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3, key4, value4,
                key5, value5, key6, value6);
    }

    /**
     * create mutable map
     */
    static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2,
                                 K key3, V value3, K key4, V value4,
                                 K key5, V value5, K key6, V value6,
                                 K key7, V value7) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3, key4, value4,
                key5, value5, key6, value6, key7, value7);
    }
}
