package net.dongliu.commons.collection;

import java.util.Collections;
import java.util.Set;

/**
 * Expanded set
 *
 * @author Liu Dong
 */
public interface ExSet<T> extends Set<T>, ExCollection<T> {

    /**
     * If set is not EnhancedSet, wrap set to EnhancedSet.
     */
    static <T> ExSet<T> wrap(Set<T> set) {
        if (set instanceof ExSet) {
            return (ExSet<T>) set;
        }
        return new ForwardingSet<>(set);
    }

    /**
     * Create immutable view of this Set.
     */
    default Set<T> immutable() {
        return Collections.unmodifiableSet(this);
    }

    /**
     * Create mutable set
     */
    static <T> ExSet<T> of() {
        return ExHashSet.of();
    }

    /**
     * Create mutable set
     */
    static <T> ExSet<T> of(T value) {
        return ExHashSet.of(value);
    }

    /**
     * Create mutable set
     */
    static <T> ExSet<T> of(T value1, T value2) {
        return ExHashSet.of(value1, value2);
    }

    /**
     * Create mutable set
     */
    static <T> ExSet<T> of(T value1, T value2, T value3) {
        return ExHashSet.of(value1, value2, value3);
    }

    /**
     * Create mutable set
     */
    static <T> ExSet<T> of(T value1, T value2, T value3, T value4) {
        return ExHashSet.of(value1, value2, value3, value4);
    }

    /**
     * Create mutable set
     */
    static <T> ExSet<T> of(T value1, T value2, T value3, T value4, T value5) {
        return ExHashSet.of(value1, value2, value3, value4, value5);
    }

    /**
     * Create mutable set
     */
    static <T> ExSet<T> of(T value1, T value2, T value3, T value4, T value5, T value6) {
        return ExHashSet.of(value1, value2, value3, value4, value5, value6);
    }

    /**
     * Create mutable set
     */
    static <T> ExSet<T> of(T value1, T value2, T value3, T value4, T value5, T value6,
                                 T value7) {
        return ExHashSet.of(value1, value2, value3, value4, value5, value6, value7);
    }

    /**
     * create mutable set
     */
    @SafeVarargs
    static <T> ExSet<T> of(T... values) {
        return ExHashSet.of(values);
    }
}
