package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 * Expanded tree set
 *
 * @author Liu Dong
 */
public class ExTreeSet<T> extends TreeSet<T> implements ExSet<T> {
    private static final long serialVersionUID = 5134658584246179022L;

    public ExTreeSet() {
    }

    public ExTreeSet(Comparator<? super T> comparator) {
        super(comparator);
    }

    public ExTreeSet(Collection<? extends T> c) {
        super(c);
    }

    public ExTreeSet(SortedSet<T> s) {
        super(s);
    }


    /**
     * Create mutable set
     */
    public static <T> ExTreeSet<T> of() {
        return new ExTreeSet<>();
    }

    /**
     * Create mutable set
     */
    public static <T> ExTreeSet<T> of(T value) {
        ExTreeSet<T> list = new ExTreeSet<>();
        list.add(value);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExTreeSet<T> of(T value1, T value2) {
        ExTreeSet<T> list = new ExTreeSet<>();
        list.add(value1);
        list.add(value2);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExTreeSet<T> of(T value1, T value2, T value3) {
        ExTreeSet<T> list = new ExTreeSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExTreeSet<T> of(T value1, T value2, T value3, T value4) {
        ExTreeSet<T> list = new ExTreeSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExTreeSet<T> of(T value1, T value2, T value3, T value4, T value5) {
        ExTreeSet<T> list = new ExTreeSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExTreeSet<T> of(T value1, T value2, T value3, T value4, T value5,
                                              T value6) {
        ExTreeSet<T> list = new ExTreeSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        return list;
    }

    /**
     * Create mutable set
     */
    public static <T> ExTreeSet<T> of(T value1, T value2, T value3, T value4, T value5,
                                              T value6, T value7) {
        ExTreeSet<T> list = new ExTreeSet<>();
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        list.add(value7);
        return list;
    }

    @SafeVarargs
    public static <T> ExTreeSet<T> of(T... values) {
        ExTreeSet<T> list = new ExTreeSet<>();
        list.addAll(values);
        return list;
    }
}
