package net.dongliu.commons.collection;

import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.*;
import java.util.stream.DoubleStream;

/**
 * Wrap DoubleStream, forward all operations to inner stream
 *
 * @author Liu Dong
 */
class ForwardingDoubleStream implements ExDoubleStream {
    private final DoubleStream stream;

    ForwardingDoubleStream(DoubleStream stream) {
        this.stream = stream;
    }

    @Override
    public ExDoubleStream filter(DoublePredicate predicate) {
        return ExDoubleStream.of(stream.filter(predicate));
    }

    @Override
    public ExDoubleStream map(DoubleUnaryOperator mapper) {
        return ExDoubleStream.of(stream.map(mapper));
    }

    @Override
    public <U> ExStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return ExStream.wrap(stream.mapToObj(mapper));
    }

    @Override
    public ExIntStream mapToInt(DoubleToIntFunction mapper) {
        return ExIntStream.of(stream.mapToInt(mapper));
    }

    @Override
    public ExLongStream mapToLong(DoubleToLongFunction mapper) {
        return ExLongStream.of(stream.mapToLong(mapper));
    }

    @Override
    public ExDoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        return ExDoubleStream.of(stream.flatMap(mapper));
    }

    @Override
    public ExDoubleStream distinct() {
        return ExDoubleStream.of(stream.distinct());
    }

    @Override
    public ExDoubleStream sorted() {
        return ExDoubleStream.of(stream.sorted());
    }

    @Override
    public ExDoubleStream peek(DoubleConsumer action) {
        return ExDoubleStream.of(stream.peek(action));
    }

    @Override
    public ExDoubleStream limit(long maxSize) {
        return ExDoubleStream.of(stream.limit(maxSize));
    }

    @Override
    public ExDoubleStream skip(long n) {
        return ExDoubleStream.of(stream.skip(n));
    }

    @Override
    public void forEach(DoubleConsumer action) {
        stream.forEach(action);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        stream.forEachOrdered(action);
    }

    @Override
    public double[] toArray() {
        return stream.toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return stream.reduce(identity, op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        return stream.reduce(op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return stream.collect(supplier, accumulator, combiner);
    }

    @Override
    public double sum() {
        return stream.sum();
    }

    @Override
    public OptionalDouble min() {
        return stream.min();
    }

    @Override
    public OptionalDouble max() {
        return stream.max();
    }

    @Override
    public long count() {
        return stream.count();
    }

    @Override
    public OptionalDouble average() {
        return stream.average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return stream.summaryStatistics();
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return stream.noneMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        return stream.findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        return stream.findAny();
    }

    @Override
    public ExStream<Double> boxed() {
        return ExStream.wrap(stream.boxed());
    }

    @Override
    public ExDoubleStream sequential() {
        return ExDoubleStream.of(stream.sequential());
    }

    @Override
    public ExDoubleStream parallel() {
        return ExDoubleStream.of(stream.parallel());
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return stream.iterator();
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return stream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return stream.isParallel();
    }

    @Override
    public ExDoubleStream unordered() {
        return ExDoubleStream.of(stream.unordered());
    }

    @Override
    public ExDoubleStream onClose(Runnable closeHandler) {
        return ExDoubleStream.of(stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        stream.close();
    }
}
