package net.dongliu.commons.collection;

import java.util.*;
import java.util.function.*;
import java.util.stream.IntStream;

/**
 * Wrap IntStream, forward all operations to inner stream
 *
 * @author Liu Dong
 */
class ForwardingIntStream implements ExIntStream {
    private final IntStream stream;

    ForwardingIntStream(IntStream stream) {
        this.stream = stream;
    }

    @Override
    public void close() {
        stream.close();
    }

    @Override
    public ExIntStream filter(IntPredicate predicate) {
        return ExIntStream.of(stream.filter(predicate));
    }

    @Override
    public ExIntStream map(IntUnaryOperator mapper) {
        return ExIntStream.of(stream.map(mapper));
    }

    @Override
    public <U> ExStream<U> mapToObj(IntFunction<? extends U> mapper) {
        return ExStream.wrap(stream.mapToObj(mapper));
    }

    @Override
    public ExLongStream mapToLong(IntToLongFunction mapper) {
        return ExLongStream.of(stream.mapToLong(mapper));
    }

    @Override
    public ExDoubleStream mapToDouble(IntToDoubleFunction mapper) {
        return ExDoubleStream.of(stream.mapToDouble(mapper));
    }

    @Override
    public ExIntStream flatMap(IntFunction<? extends IntStream> mapper) {
        return ExIntStream.of(stream.flatMap(mapper));
    }

    @Override
    public ExIntStream distinct() {
        return ExIntStream.of(stream.distinct());
    }

    @Override
    public ExIntStream sorted() {
        return ExIntStream.of(stream.sorted());
    }

    @Override
    public ExIntStream peek(IntConsumer action) {
        return ExIntStream.of(stream.peek(action));
    }

    @Override
    public ExIntStream limit(long maxSize) {
        return ExIntStream.of(stream.limit(maxSize));
    }

    @Override
    public ExIntStream skip(long n) {
        return ExIntStream.of(stream.skip(n));
    }

    @Override
    public void forEach(IntConsumer action) {
        stream.forEach(action);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        stream.forEachOrdered(action);
    }

    @Override
    public int[] toArray() {
        return stream.toArray();
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        return stream.reduce(identity, op);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        return stream.reduce(op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return stream.collect(supplier, accumulator, combiner);
    }

    @Override
    public int sum() {
        return stream.sum();
    }

    @Override
    public OptionalInt min() {
        return stream.min();
    }

    @Override
    public OptionalInt max() {
        return stream.max();
    }

    @Override
    public long count() {
        return stream.count();
    }

    @Override
    public OptionalDouble average() {
        return stream.average();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return stream.summaryStatistics();
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return stream.noneMatch(predicate);
    }

    @Override
    public OptionalInt findFirst() {
        return stream.findFirst();
    }

    @Override
    public OptionalInt findAny() {
        return stream.findAny();
    }

    @Override
    public ExLongStream asLongStream() {
        return ExLongStream.of(stream.asLongStream());
    }

    @Override
    public ExDoubleStream asDoubleStream() {
        return ExDoubleStream.of(stream.asDoubleStream());
    }

    @Override
    public ExStream<Integer> boxed() {
        return ExStream.wrap(stream.boxed());
    }

    @Override
    public ExIntStream sequential() {
        return ExIntStream.of(stream.sequential());
    }

    @Override
    public ExIntStream parallel() {
        return ExIntStream.of(stream.parallel());
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return stream.iterator();
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return stream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return stream.isParallel();
    }

    @Override
    public ExIntStream unordered() {
        return ExIntStream.of(stream.unordered());
    }

    @Override
    public ExIntStream onClose(Runnable closeHandler) {
        return ExIntStream.of(stream.onClose(closeHandler));
    }
}
