package net.dongliu.commons.collection;

import java.util.*;
import java.util.function.*;
import java.util.stream.LongStream;

/**
 * Wrap LongStream, forward all operations to inner stream
 *
 * @author Liu Dong
 */
class ForwardingLongStream implements ExLongStream {
    private final LongStream stream;

    public ForwardingLongStream(LongStream stream) {
        this.stream = stream;
    }

    @Override
    public ExLongStream filter(LongPredicate predicate) {
        return ExLongStream.of(stream.filter(predicate));
    }

    @Override
    public ExLongStream map(LongUnaryOperator mapper) {
        return ExLongStream.of(stream.map(mapper));
    }

    @Override
    public <U> ExStream<U> mapToObj(LongFunction<? extends U> mapper) {
        return ExStream.wrap(stream.mapToObj(mapper));
    }

    @Override
    public ExIntStream mapToInt(LongToIntFunction mapper) {
        return ExIntStream.of(stream.mapToInt(mapper));
    }

    @Override
    public ExDoubleStream mapToDouble(LongToDoubleFunction mapper) {
        return ExDoubleStream.of(stream.mapToDouble(mapper));
    }

    @Override
    public ExLongStream flatMap(LongFunction<? extends LongStream> mapper) {
        return ExLongStream.of(stream.flatMap(mapper));
    }

    @Override
    public ExLongStream distinct() {
        return ExLongStream.of(stream.distinct());
    }

    @Override
    public ExLongStream sorted() {
        return ExLongStream.of(stream.sorted());
    }

    @Override
    public ExLongStream peek(LongConsumer action) {
        return ExLongStream.of(stream.peek(action));
    }

    @Override
    public ExLongStream limit(long maxSize) {
        return ExLongStream.of(stream.limit(maxSize));
    }

    @Override
    public ExLongStream skip(long n) {
        return ExLongStream.of(stream.skip(n));
    }

    @Override
    public void forEach(LongConsumer action) {
        stream.forEach(action);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        stream.forEachOrdered(action);
    }

    @Override
    public long[] toArray() {
        return stream.toArray();
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        return stream.reduce(identity, op);
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        return stream.reduce(op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return stream.collect(supplier, accumulator, combiner);
    }

    @Override
    public long sum() {
        return stream.sum();
    }

    @Override
    public OptionalLong min() {
        return stream.min();
    }

    @Override
    public OptionalLong max() {
        return stream.max();
    }

    @Override
    public long count() {
        return stream.count();
    }

    @Override
    public OptionalDouble average() {
        return stream.average();
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return stream.summaryStatistics();
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        return stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        return stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return stream.noneMatch(predicate);
    }

    @Override
    public OptionalLong findFirst() {
        return stream.findFirst();
    }

    @Override
    public OptionalLong findAny() {
        return stream.findAny();
    }

    @Override
    public ExDoubleStream asDoubleStream() {
        return ExDoubleStream.of(stream.asDoubleStream());
    }

    @Override
    public ExStream<Long> boxed() {
        return ExStream.wrap(stream.boxed());
    }

    @Override
    public ExLongStream sequential() {
        return ExLongStream.of(stream.sequential());
    }

    @Override
    public ExLongStream parallel() {
        return ExLongStream.of(stream.parallel());
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return stream.iterator();
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return stream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return stream.isParallel();
    }

    @Override
    public ExLongStream unordered() {
        return ExLongStream.of(stream.unordered());
    }

    @Override
    public ExLongStream onClose(Runnable closeHandler) {
        return ExLongStream.of(stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        stream.close();
    }
}
