package net.dongliu.commons.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.*;
import java.util.stream.*;

/**
 * Wrap a stream, and forward all operations to inner stream.
 *
 * @author Liu Dong
 */
class ForwardingStream<T> implements ExStream<T> {

    private final Stream<T> stream;

    ForwardingStream(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    public ExStream<T> filter(Predicate<? super T> predicate) {
        return ExStream.wrap(stream.filter(predicate));
    }

    @Override
    public <R> ExStream<R> map(Function<? super T, ? extends R> mapper) {
        return ExStream.wrap(stream.map(mapper));
    }

    @Override
    public ExIntStream mapToInt(ToIntFunction<? super T> mapper) {
        return ExIntStream.of(stream.mapToInt(mapper));
    }

    @Override
    public ExLongStream mapToLong(ToLongFunction<? super T> mapper) {
        return ExLongStream.of(stream.mapToLong(mapper));
    }

    @Override
    public ExDoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return ExDoubleStream.of(stream.mapToDouble(mapper));
    }

    @Override
    public <R> ExStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return ExStream.wrap(stream.flatMap(mapper));
    }

    @Override
    public ExIntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return ExIntStream.of(stream.flatMapToInt(mapper));
    }

    @Override
    public ExLongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return ExLongStream.of(stream.flatMapToLong(mapper));
    }

    @Override
    public ExDoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return ExDoubleStream.of(stream.flatMapToDouble(mapper));
    }

    @Override
    public ExStream<T> distinct() {
        return ExStream.wrap(stream.distinct());
    }

    @Override
    public ExStream<T> sorted() {
        return ExStream.wrap(stream.sorted());
    }

    @Override
    public ExStream<T> sorted(Comparator<? super T> comparator) {
        return ExStream.wrap(stream.sorted(comparator));
    }

    @Override
    public ExStream<T> peek(Consumer<? super T> action) {
        return ExStream.wrap(stream.peek(action));
    }

    @Override
    public ExStream<T> limit(long maxSize) {
        return ExStream.wrap(stream.limit(maxSize));
    }

    @Override
    public ExStream<T> skip(long n) {
        return ExStream.wrap(stream.skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        stream.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        stream.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return stream.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return stream.toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return stream.reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return stream.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return stream.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return stream.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return stream.collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return stream.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return stream.max(comparator);
    }

    @Override
    public long count() {
        return stream.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return stream.noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return stream.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return stream.findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return stream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return stream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return stream.isParallel();
    }

    @Override
    public ExStream<T> sequential() {
        return ExStream.wrap(stream.sequential());
    }

    @Override
    public ExStream<T> parallel() {
        return ExStream.wrap(stream.parallel());
    }

    @Override
    public ExStream<T> unordered() {
        return ExStream.wrap(stream.unordered());
    }

    @Override
    public ExStream<T> onClose(Runnable closeHandler) {
        return ExStream.wrap(stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        stream.close();
    }
}
