/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.Base64;

public class EncodingUtils {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String hex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] decodeHex(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return data;
    }

    public static String base64(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Base64.Encoder encoder = Base64.getEncoder();
        return new String(encoder.encode(bytes));
    }

    public static byte[] decodeBase64(String base64) {
        if (base64 == null) {
            return null;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64.getBytes());
    }

    public static String urlSafeBase64(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Base64.Encoder encoder = Base64.getUrlEncoder();
        return new String(encoder.encode(bytes));
    }

    public static byte[] decodeUrlSafeBase64(String base64) {
        if (base64 == null) {
            return null;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64.getBytes());
    }

    public static String mimeBase64(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Base64.Encoder encoder = Base64.getMimeEncoder();
        return new String(encoder.encode(bytes));
    }

    public static byte[] decodeMimeSafeBase64(String base64) {
        if (base64 == null) {
            return null;
        }
        Base64.Decoder decoder = Base64.getMimeDecoder();
        return decoder.decode(base64.getBytes());
    }
}

