/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dongliu.commons.collection.ExList;
import net.dongliu.commons.collection.ExMap;
import net.dongliu.commons.collection.ExSet;

public class ObjectUtils {
    public static <T> T nonNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static String nonNull(String value) {
        return value == null ? "" : value;
    }

    public static <T> List<T> nonNull(List<T> list) {
        return list == null ? ExList.of() : list;
    }

    public static <T> Set<T> nonNull(Set<T> set) {
        return set == null ? ExSet.of() : set;
    }

    public static <K, V> Map<K, V> nonNull(Map<K, V> map) {
        return map == null ? ExMap.of() : map;
    }

    public static boolean unbox(Boolean value) {
        return value == null ? false : value;
    }

    public static char unbox(Character value) {
        return value == null ? (char)'0' : (char)value.charValue();
    }

    public static byte unbox(Byte value) {
        return value == null ? (byte)0 : value;
    }

    public static short unbox(Short value) {
        return value == null ? (short)0 : value;
    }

    public static int unbox(Integer value) {
        return value == null ? 0 : value;
    }

    public static long unbox(Long value) {
        return value == null ? 0L : value;
    }

    public static float unbox(Float value) {
        return value == null ? 0.0f : value.floatValue();
    }

    public static double unbox(Double value) {
        return value == null ? 0.0 : value;
    }
}

