/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.lang.reflect.Field;

public class ReflectUtils {
    public static boolean isPrimitive(Class cls) {
        return cls == Boolean.TYPE || cls == Character.TYPE || cls == Integer.TYPE || cls == Byte.TYPE || cls == Short.TYPE || cls == Long.TYPE || cls == Float.TYPE || cls == Double.TYPE;
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    private static Field getObjectField(Object o, String name) {
        Field field;
        try {
            field = o.getClass().getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        field.setAccessible(true);
        return field;
    }

    public static <T> T getField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return (T)field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean getBooleanField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return field.getBoolean(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getIntField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return field.getInt(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getLongField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return field.getLong(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static float getFloatField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return field.getFloat(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static double getDoubleField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return field.getDouble(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte getByteField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return field.getByte(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static short getShortField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return field.getShort(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static char getCharField(Object o, String name) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            return field.getChar(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object o, String name, Object value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.set(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBooleanField(Object o, String name, boolean value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.setBoolean(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setIntField(Object o, String name, int value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.setInt(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setLongField(Object o, String name, long value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.setLong(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFloatField(Object o, String name, float value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.setFloat(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setDoubleField(Object o, String name, double value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.setDouble(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setByteField(Object o, String name, byte value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.setByte(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setShortField(Object o, String name, short value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.setShort(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setCharField(Object o, String name, char value) {
        Field field = ReflectUtils.getObjectField(o, name);
        try {
            field.setChar(o, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getStaticField(Class cls, String name) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            return (T)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getClassField(Class cls, String name) {
        Field field;
        try {
            field = cls.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return field;
    }

    public static int getStaticIntField(Class cls, String name) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            return field.getInt(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getStaticLongField(Class cls, String name) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            return field.getLong(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static float getStaticFloatField(Class cls, String name) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            return field.getFloat(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static double getStaticDoubleField(Class cls, String name) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            return field.getDouble(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte getStaticByteField(Class cls, String name) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            return field.getByte(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static short getStaticShortField(Class cls, String name) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            return field.getShort(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static char getStaticCharField(Class cls, String name) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            return field.getChar(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(Class cls, String name, Object value) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticIntField(Class cls, String name, int value) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            field.setInt(null, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticLongField(Class cls, String name, long value) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            field.setLong(null, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticFloatField(Class cls, String name, float value) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            field.setFloat(null, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticDoubleField(Class cls, String name, double value) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            field.setDouble(null, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticByteField(Class cls, String name, byte value) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            field.setByte(null, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticShortField(Class cls, String name, short value) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            field.setShort(null, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticCharField(Class cls, String name, char value) {
        Field field = ReflectUtils.getClassField(cls, name);
        try {
            field.setChar(null, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

