/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;
import sun.misc.VM;

public class UnsafeUtils {
    private static final Unsafe unsafe;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final boolean BIG_ENDIAN;
    private static final long ARRAY_BASE_OFFSET;
    private static final int PAGE_SIZE;
    private static final boolean PA;
    private static final boolean UNALIGNED_ACCESS;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    static void throwException(Throwable t) {
        unsafe.throwException(t);
    }

    public static String getSystemProperty(final String key, String def) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null) {
            return def;
        }
        return value;
    }

    public static long directBufferAddress(ByteBuffer buffer) {
        return UnsafeUtils.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    static long arrayBaseOffset() {
        return unsafe.arrayBaseOffset(byte[].class);
    }

    static Object getObject(Object object, long fieldOffset) {
        return unsafe.getObject(object, fieldOffset);
    }

    static Object getObjectVolatile(Object object, long fieldOffset) {
        return unsafe.getObjectVolatile(object, fieldOffset);
    }

    static int getInt(Object object, long fieldOffset) {
        return unsafe.getInt(object, fieldOffset);
    }

    private static long getLong(Object object, long fieldOffset) {
        return unsafe.getLong(object, fieldOffset);
    }

    static long objectFieldOffset(Field field) {
        return unsafe.objectFieldOffset(field);
    }

    public static byte getByte(long address) {
        return unsafe.getByte(address);
    }

    static short getShort(long address) {
        if (UNALIGNED_ACCESS) {
            return unsafe.getShort(address);
        }
        if (BIG_ENDIAN) {
            return (short)(UnsafeUtils.getByte(address) << 8 | UnsafeUtils.getByte(address + 1L) & 0xFF);
        }
        return (short)(UnsafeUtils.getByte(address + 1L) << 8 | UnsafeUtils.getByte(address) & 0xFF);
    }

    static int getInt(long address) {
        if (UNALIGNED_ACCESS) {
            return unsafe.getInt(address);
        }
        if (BIG_ENDIAN) {
            return UnsafeUtils.getByte(address) << 24 | (UnsafeUtils.getByte(address + 1L) & 0xFF) << 16 | (UnsafeUtils.getByte(address + 2L) & 0xFF) << 8 | UnsafeUtils.getByte(address + 3L) & 0xFF;
        }
        return UnsafeUtils.getByte(address + 3L) << 24 | (UnsafeUtils.getByte(address + 2L) & 0xFF) << 16 | (UnsafeUtils.getByte(address + 1L) & 0xFF) << 8 | UnsafeUtils.getByte(address) & 0xFF;
    }

    static long getLong(long address) {
        if (UNALIGNED_ACCESS) {
            return unsafe.getLong(address);
        }
        if (BIG_ENDIAN) {
            return (long)UnsafeUtils.getByte(address) << 56 | ((long)UnsafeUtils.getByte(address + 1L) & 0xFFL) << 48 | ((long)UnsafeUtils.getByte(address + 2L) & 0xFFL) << 40 | ((long)UnsafeUtils.getByte(address + 3L) & 0xFFL) << 32 | ((long)UnsafeUtils.getByte(address + 4L) & 0xFFL) << 24 | ((long)UnsafeUtils.getByte(address + 5L) & 0xFFL) << 16 | ((long)UnsafeUtils.getByte(address + 6L) & 0xFFL) << 8 | (long)UnsafeUtils.getByte(address + 7L) & 0xFFL;
        }
        return (long)UnsafeUtils.getByte(address + 7L) << 56 | ((long)UnsafeUtils.getByte(address + 6L) & 0xFFL) << 48 | ((long)UnsafeUtils.getByte(address + 5L) & 0xFFL) << 40 | ((long)UnsafeUtils.getByte(address + 4L) & 0xFFL) << 32 | ((long)UnsafeUtils.getByte(address + 3L) & 0xFFL) << 24 | ((long)UnsafeUtils.getByte(address + 2L) & 0xFFL) << 16 | ((long)UnsafeUtils.getByte(address + 1L) & 0xFFL) << 8 | (long)UnsafeUtils.getByte(address) & 0xFFL;
    }

    static void putOrderedObject(Object object, long address, Object value) {
        unsafe.putOrderedObject(object, address, value);
    }

    static void putByte(long address, byte value) {
        unsafe.putByte(address, value);
    }

    static void putShort(long address, short value) {
        if (UNALIGNED_ACCESS) {
            unsafe.putShort(address, value);
        } else if (BIG_ENDIAN) {
            UnsafeUtils.putByte(address, (byte)(value >>> 8));
            UnsafeUtils.putByte(address + 1L, (byte)value);
        } else {
            UnsafeUtils.putByte(address + 1L, (byte)(value >>> 8));
            UnsafeUtils.putByte(address, (byte)value);
        }
    }

    static void putInt(long address, int value) {
        if (UNALIGNED_ACCESS) {
            unsafe.putInt(address, value);
        } else if (BIG_ENDIAN) {
            UnsafeUtils.putByte(address, (byte)(value >>> 24));
            UnsafeUtils.putByte(address + 1L, (byte)(value >>> 16));
            UnsafeUtils.putByte(address + 2L, (byte)(value >>> 8));
            UnsafeUtils.putByte(address + 3L, (byte)value);
        } else {
            UnsafeUtils.putByte(address + 3L, (byte)(value >>> 24));
            UnsafeUtils.putByte(address + 2L, (byte)(value >>> 16));
            UnsafeUtils.putByte(address + 1L, (byte)(value >>> 8));
            UnsafeUtils.putByte(address, (byte)value);
        }
    }

    static void putLong(long address, long value) {
        if (UNALIGNED_ACCESS) {
            unsafe.putLong(address, value);
        } else if (BIG_ENDIAN) {
            UnsafeUtils.putByte(address, (byte)(value >>> 56));
            UnsafeUtils.putByte(address + 1L, (byte)(value >>> 48));
            UnsafeUtils.putByte(address + 2L, (byte)(value >>> 40));
            UnsafeUtils.putByte(address + 3L, (byte)(value >>> 32));
            UnsafeUtils.putByte(address + 4L, (byte)(value >>> 24));
            UnsafeUtils.putByte(address + 5L, (byte)(value >>> 16));
            UnsafeUtils.putByte(address + 6L, (byte)(value >>> 8));
            UnsafeUtils.putByte(address + 7L, (byte)value);
        } else {
            UnsafeUtils.putByte(address + 7L, (byte)(value >>> 56));
            UnsafeUtils.putByte(address + 6L, (byte)(value >>> 48));
            UnsafeUtils.putByte(address + 5L, (byte)(value >>> 40));
            UnsafeUtils.putByte(address + 4L, (byte)(value >>> 32));
            UnsafeUtils.putByte(address + 3L, (byte)(value >>> 24));
            UnsafeUtils.putByte(address + 2L, (byte)(value >>> 16));
            UnsafeUtils.putByte(address + 1L, (byte)(value >>> 8));
            UnsafeUtils.putByte(address, (byte)value);
        }
    }

    public static void copyMemory(long srcAddr, long dstAddr, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            unsafe.copyMemory(srcAddr, dstAddr, size);
            length -= size;
            srcAddr += size;
            dstAddr += size;
        }
    }

    static void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            unsafe.copyMemory(src, srcOffset, dst, dstOffset, size);
            length -= size;
            srcOffset += size;
            dstOffset += size;
        }
    }

    public static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    public static int addressSize() {
        return unsafe.addressSize();
    }

    public static long allocateMemory(long size) {
        return unsafe.allocateMemory(size);
    }

    public static void freeMemory(long address) {
        unsafe.freeMemory(address);
    }

    public static void copyMemory(long srcAddr, byte[] dst, int dstIndex, long length) {
        UnsafeUtils.copyMemory(null, srcAddr, dst, ARRAY_BASE_OFFSET + (long)dstIndex, length);
    }

    public static void copyMemory(byte[] src, int srcIndex, long dstAddr, long length) {
        UnsafeUtils.copyMemory(src, ARRAY_BASE_OFFSET + (long)srcIndex, null, dstAddr, length);
    }

    public static Unsafe getUnsafe() {
        return unsafe;
    }

    static {
        boolean unalignedAccess;
        Unsafe _unsafe;
        Field addressField;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        PA = VM.isDirectMemoryPageAligned();
        ByteBuffer direct = ByteBuffer.allocateDirect(1);
        try {
            addressField = Buffer.class.getDeclaredField("address");
            addressField.setAccessible(true);
            if (addressField.getLong(ByteBuffer.allocate(1)) != 0L) {
                addressField = null;
            } else if (addressField.getLong(direct) == 0L) {
                addressField = null;
            }
        }
        catch (Throwable t) {
            addressField = null;
        }
        if (addressField == null) {
            throw new RuntimeException("ByteBuffer addressField not found");
        }
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            _unsafe = (Unsafe)unsafeField.get(null);
            if (_unsafe != null) {
                _unsafe.getClass().getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            }
        }
        catch (Throwable cause) {
            _unsafe = null;
        }
        if (_unsafe == null) {
            throw new RuntimeException("Unsafe not available");
        }
        unsafe = _unsafe;
        ADDRESS_FIELD_OFFSET = UnsafeUtils.objectFieldOffset(addressField);
        try {
            Class<?> bitsClass = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
            Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
            unalignedMethod.setAccessible(true);
            unalignedAccess = Boolean.TRUE.equals(unalignedMethod.invoke(null, new Object[0]));
            Method psMethod = bitsClass.getDeclaredMethod("pageSize", new Class[0]);
            psMethod.setAccessible(true);
            PAGE_SIZE = (Integer)psMethod.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        UNALIGNED_ACCESS = unalignedAccess;
        ARRAY_BASE_OFFSET = UnsafeUtils.arrayBaseOffset();
    }
}

