/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.dongliu.commons.collection.ExList;
import net.dongliu.commons.collection.ForwardingList;

public class Array<T>
extends AbstractList<T>
implements RandomAccess,
Serializable,
ExList<T> {
    private static final long serialVersionUID = -2764017481108945198L;
    private final T[] array;

    public Array(T[] array) {
        this.array = Objects.requireNonNull(array);
    }

    @SafeVarargs
    public static <T> Array<T> of(T ... values) {
        return new Array<T>(values);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.array.clone();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        int size = this.size();
        if (a.length < size) {
            return Arrays.copyOf(this.array, size, a.getClass());
        }
        System.arraycopy(this.array, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public T get(int index) {
        return this.array[index];
    }

    @Override
    public T set(int index, T element) {
        T oldValue = this.array[index];
        this.array[index] = element;
        return oldValue;
    }

    @Override
    public int indexOf(Object o) {
        T[] a = this.array;
        if (o == null) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (!o.equals(a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.array, 16);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        for (T e : this.array) {
            action.accept(e);
        }
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        Objects.requireNonNull(operator);
        T[] a = this.array;
        for (int i = 0; i < a.length; ++i) {
            a[i] = operator.apply(a[i]);
        }
    }

    @Override
    public void sort(Comparator<? super T> c) {
        Arrays.sort(this.array, c);
    }

    @Override
    public ExList<T> subList(int fromIndex, int toIndex) {
        return new ForwardingList(super.subList(fromIndex, toIndex));
    }
}

