/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.StreamSupport;
import net.dongliu.commons.collection.ExDoubleStream;
import net.dongliu.commons.collection.ExIntStream;
import net.dongliu.commons.collection.ExLongStream;
import net.dongliu.commons.collection.ExStream;
import net.dongliu.commons.collection.ForwardingCollection;

public interface ExCollection<T>
extends Collection<T> {
    public static <T> ForwardingCollection<T> wrap(Collection<T> c) {
        if (c instanceof ForwardingCollection) {
            return (ForwardingCollection)c;
        }
        return new ForwardingCollection<T>(c);
    }

    @Override
    default public ExStream<T> stream() {
        return ExStream.wrap(StreamSupport.stream(this.spliterator(), false));
    }

    @Override
    default public ExStream<T> parallelStream() {
        return ExStream.wrap(StreamSupport.stream(this.spliterator(), true));
    }

    default public Collection<T> immutable() {
        return Collections.unmodifiableCollection(this);
    }

    default public void addAll(T ... values) {
        Collections.addAll(this, values);
    }

    default public T[] toArray(Class<T> cls) {
        Object[] array = (Object[])Array.newInstance(cls, this.size());
        int i = 0;
        for (Object value : this) {
            array[i++] = value;
        }
        return array;
    }

    default public String join() {
        return this.join("");
    }

    default public String join(String delimiter) {
        return this.join(delimiter, "", "");
    }

    default public String join(String delimiter, String prefix, String suffix) {
        StringJoiner joiner = new StringJoiner(delimiter, prefix, suffix);
        for (Object e : this) {
            joiner.add(e == null ? "null" : e.toString());
        }
        return joiner.toString();
    }

    default public <R> ExStream<R> map(Function<? super T, ? extends R> mapper) {
        return ExStream.wrap(this.stream().map((Function)mapper));
    }

    default public ExIntStream mapToInt(ToIntFunction<? super T> mapper) {
        return ExIntStream.of(this.stream().mapToInt((ToIntFunction)mapper));
    }

    default public ExLongStream mapToLong(ToLongFunction<? super T> mapper) {
        return ExLongStream.of(this.stream().mapToLong((ToLongFunction)mapper));
    }

    default public ExDoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return ExDoubleStream.of(this.stream().mapToDouble((ToDoubleFunction)mapper));
    }

    default public ExStream<T> filter(Predicate<? super T> predicate) {
        return ExStream.wrap(this.stream().filter((Predicate)predicate));
    }
}

