/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Collections;
import java.util.List;
import net.dongliu.commons.collection.ExArrayList;
import net.dongliu.commons.collection.ExCollection;
import net.dongliu.commons.collection.ForwardingList;

public interface ExList<T>
extends List<T>,
ExCollection<T> {
    @Override
    public ExList<T> subList(int var1, int var2);

    public static <T> ExList<T> wrap(List<T> list) {
        if (list instanceof ExList) {
            return (ExList)list;
        }
        return new ForwardingList<T>(list);
    }

    @Override
    default public List<T> immutable() {
        return Collections.unmodifiableList(this);
    }

    public static <T> ExList<T> of() {
        return ExArrayList.of();
    }

    public static <T> ExList<T> of(T value) {
        return ExArrayList.of(value);
    }

    public static <T> ExList<T> of(T value1, T value2) {
        return ExArrayList.of(value1, value2);
    }

    public static <T> ExList<T> of(T value1, T value2, T value3) {
        return ExArrayList.of(value1, value2, value3);
    }

    public static <T> ExList<T> of(T value1, T value2, T value3, T value4) {
        return ExArrayList.of(value1, value2, value3, value4);
    }

    public static <T> ExList<T> of(T value1, T value2, T value3, T value4, T value5) {
        return ExArrayList.of(value1, value2, value3, value4, value5);
    }

    public static <T> ExList<T> of(T value1, T value2, T value3, T value4, T value5, T value6) {
        return ExArrayList.of(value1, value2, value3, value4, value5, value6);
    }

    public static <T> ExList<T> of(T value1, T value2, T value3, T value4, T value5, T value6, T value7) {
        return ExArrayList.of(value1, value2, value3, value4, value5, value6, value7);
    }

    @SafeVarargs
    public static <T> ExList<T> of(T ... values) {
        return ExArrayList.of(values);
    }
}

