/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.dongliu.commons.ObjectUtils;
import net.dongliu.commons.collection.ExHashMap;
import net.dongliu.commons.collection.ExStream;
import net.dongliu.commons.collection.ForwardingMap;
import net.dongliu.commons.collection.Pair;

public interface ExMap<K, V>
extends Map<K, V> {
    public static <K, V> ExMap<K, V> wrap(Map<K, V> map) {
        if (map instanceof ExMap) {
            return (ExMap)map;
        }
        return new ForwardingMap<K, V>(map);
    }

    default public ExStream<K> keyStream() {
        return ExStream.wrap(this.keySet().stream());
    }

    default public ExStream<V> valueStream() {
        return ExStream.wrap(this.values().stream());
    }

    default public ExStream<Map.Entry<K, V>> entryStream() {
        return ExStream.wrap(this.entrySet().stream());
    }

    default public Map<K, V> immutable() {
        return Collections.unmodifiableMap(this);
    }

    default public V getNonNull(K key, V defaultValue) {
        return ObjectUtils.nonNull(this.get(key), defaultValue);
    }

    public static <K, V> ExMap<K, V> of() {
        return ExHashMap.of();
    }

    @SafeVarargs
    public static <K, V> ExMap<K, V> of(Pair<K, V> ... pairs) {
        return ExHashMap.of(pairs);
    }

    public static <K, V> ExHashMap<K, V> of(Collection<Pair<K, V>> pairs) {
        return ExHashMap.of(pairs);
    }

    public static <K, V> ExMap<K, V> of(K key, V value) {
        return ExHashMap.of(key, value);
    }

    public static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2) {
        return ExHashMap.of(key1, value1, key2, value2);
    }

    public static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3);
    }

    public static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6);
    }

    public static <K, V> ExMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6, K key7, V value7) {
        return ExHashMap.of(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7);
    }
}

