/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.dongliu.commons.collection.CollectorImpl;
import net.dongliu.commons.collection.ExArrayList;
import net.dongliu.commons.collection.ExDoubleStream;
import net.dongliu.commons.collection.ExHashMap;
import net.dongliu.commons.collection.ExHashSet;
import net.dongliu.commons.collection.ExIntStream;
import net.dongliu.commons.collection.ExLinkedHashMap;
import net.dongliu.commons.collection.ExLinkedHashSet;
import net.dongliu.commons.collection.ExLinkedList;
import net.dongliu.commons.collection.ExList;
import net.dongliu.commons.collection.ExLongStream;
import net.dongliu.commons.collection.ExMap;
import net.dongliu.commons.collection.ExSet;
import net.dongliu.commons.collection.ExTreeMap;
import net.dongliu.commons.collection.ExTreeSet;
import net.dongliu.commons.collection.ForwardingStream;

public interface ExStream<T>
extends Stream<T> {
    public static <T> ExStream<T> wrap(Stream<T> stream) {
        if (stream instanceof ForwardingStream) {
            return (ForwardingStream)stream;
        }
        return new ForwardingStream<T>(stream);
    }

    @SafeVarargs
    public static <T> ExStream<T> wrap(T ... stream) {
        return ExStream.wrap(Arrays.stream(stream));
    }

    @Override
    public ExStream<T> filter(Predicate<? super T> var1);

    @Override
    public <R> ExStream<R> map(Function<? super T, ? extends R> var1);

    @Override
    public ExIntStream mapToInt(ToIntFunction<? super T> var1);

    @Override
    public ExLongStream mapToLong(ToLongFunction<? super T> var1);

    @Override
    public ExDoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    @Override
    public <R> ExStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    @Override
    public ExIntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    @Override
    public ExLongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    @Override
    public ExDoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    @Override
    public ExStream<T> distinct();

    @Override
    public ExStream<T> sorted();

    @Override
    public ExStream<T> sorted(Comparator<? super T> var1);

    @Override
    public ExStream<T> peek(Consumer<? super T> var1);

    @Override
    public ExStream<T> limit(long var1);

    @Override
    public ExStream<T> skip(long var1);

    @Override
    public ExStream<T> sequential();

    @Override
    public ExStream<T> parallel();

    @Override
    public ExStream<T> unordered();

    @Override
    public ExStream<T> onClose(Runnable var1);

    @Override
    default public ExList<T> toList() {
        return this.toArrayList();
    }

    default public ExArrayList<T> toArrayList() {
        return (ExArrayList)this.collect(new CollectorImpl(ExArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CollectorImpl.CH_ID));
    }

    default public ExArrayList<T> toLinkedList() {
        return (ExArrayList)this.collect(new CollectorImpl(ExLinkedList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CollectorImpl.CH_ID));
    }

    default public ExSet<T> toSet() {
        return this.toHashSet();
    }

    default public ExHashSet<T> toHashSet() {
        return (ExHashSet)this.collect(new CollectorImpl(ExHashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CollectorImpl.CH_UNORDERED_ID));
    }

    default public ExLinkedHashSet<T> toLinkedHashSet() {
        return (ExLinkedHashSet)this.collect(new CollectorImpl(ExLinkedHashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CollectorImpl.CH_UNORDERED_ID));
    }

    default public ExTreeSet<T> toTreeSet() {
        return (ExTreeSet)this.collect(new CollectorImpl(ExTreeSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CollectorImpl.CH_UNORDERED_ID));
    }

    default public <K, U> ExMap<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.toHashMap(keyMapper, valueMapper);
    }

    default public <K, U> ExMap<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> merger) {
        return this.toHashMap(keyMapper, valueMapper, merger);
    }

    default public <K, U> ExHashMap<K, U> toHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.toHashMap(keyMapper, valueMapper, (older, newer) -> newer);
    }

    default public <K, U> ExHashMap<K, U> toHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> merger) {
        return this.collect(CollectorImpl.toMap(keyMapper, valueMapper, merger, ExHashMap::new));
    }

    default public <K, U> ExLinkedHashMap<K, U> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.toLinkedHashMap(keyMapper, valueMapper, (older, newer) -> newer);
    }

    default public <K, U> ExLinkedHashMap<K, U> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> merger) {
        return this.collect(CollectorImpl.toMap(keyMapper, valueMapper, merger, ExLinkedHashMap::new));
    }

    default public <K, U> ExTreeMap<K, U> toTreeMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.toTreeMap(keyMapper, valueMapper, (older, newer) -> newer);
    }

    default public <K, U> ExTreeMap<K, U> toTreeMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> merger) {
        return this.collect(CollectorImpl.toMap(keyMapper, valueMapper, merger, ExTreeMap::new));
    }

    default public <K, U> ConcurrentMap<K, U> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.collect(Collectors.toConcurrentMap(keyMapper, valueMapper, (older, newer) -> newer));
    }

    default public <K, U> ConcurrentMap<K, U> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> merger) {
        return this.collect(Collectors.toConcurrentMap(keyMapper, valueMapper, merger));
    }

    default public String join() {
        return this.map((T e) -> e == null ? "null" : e.toString()).collect(Collectors.joining());
    }

    default public String join(CharSequence delimiter) {
        return this.map((T e) -> e == null ? "null" : e.toString()).collect(Collectors.joining(delimiter));
    }

    default public String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.map((T e) -> e == null ? "null" : e.toString()).collect(Collectors.joining(delimiter, prefix, suffix));
    }
}

