/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.dongliu.commons.collection.ExDoubleStream;
import net.dongliu.commons.collection.ExIntStream;
import net.dongliu.commons.collection.ExLongStream;
import net.dongliu.commons.collection.ExStream;

class ForwardingStream<T>
implements ExStream<T> {
    private final Stream<T> stream;

    ForwardingStream(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    public ExStream<T> filter(Predicate<? super T> predicate) {
        return ExStream.wrap(this.stream.filter(predicate));
    }

    @Override
    public <R> ExStream<R> map(Function<? super T, ? extends R> mapper) {
        return ExStream.wrap(this.stream.map(mapper));
    }

    @Override
    public ExIntStream mapToInt(ToIntFunction<? super T> mapper) {
        return ExIntStream.of(this.stream.mapToInt(mapper));
    }

    @Override
    public ExLongStream mapToLong(ToLongFunction<? super T> mapper) {
        return ExLongStream.of(this.stream.mapToLong(mapper));
    }

    @Override
    public ExDoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return ExDoubleStream.of(this.stream.mapToDouble(mapper));
    }

    @Override
    public <R> ExStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return ExStream.wrap(this.stream.flatMap(mapper));
    }

    @Override
    public ExIntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return ExIntStream.of(this.stream.flatMapToInt(mapper));
    }

    @Override
    public ExLongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return ExLongStream.of(this.stream.flatMapToLong(mapper));
    }

    @Override
    public ExDoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return ExDoubleStream.of(this.stream.flatMapToDouble(mapper));
    }

    @Override
    public ExStream<T> distinct() {
        return ExStream.wrap(this.stream.distinct());
    }

    @Override
    public ExStream<T> sorted() {
        return ExStream.wrap(this.stream.sorted());
    }

    @Override
    public ExStream<T> sorted(Comparator<? super T> comparator) {
        return ExStream.wrap(this.stream.sorted(comparator));
    }

    @Override
    public ExStream<T> peek(Consumer<? super T> action) {
        return ExStream.wrap(this.stream.peek(action));
    }

    @Override
    public ExStream<T> limit(long maxSize) {
        return ExStream.wrap(this.stream.limit(maxSize));
    }

    @Override
    public ExStream<T> skip(long n) {
        return ExStream.wrap(this.stream.skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.stream.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.stream.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream.toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.stream.reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.stream.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.stream.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.stream.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream.collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.stream.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.stream.max(comparator);
    }

    @Override
    public long count() {
        return this.stream.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.stream.noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.stream.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.stream.findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.stream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.stream.isParallel();
    }

    @Override
    public ExStream<T> sequential() {
        return ExStream.wrap((Stream)this.stream.sequential());
    }

    @Override
    public ExStream<T> parallel() {
        return ExStream.wrap((Stream)this.stream.parallel());
    }

    @Override
    public ExStream<T> unordered() {
        return ExStream.wrap((Stream)this.stream.unordered());
    }

    @Override
    public ExStream<T> onClose(Runnable closeHandler) {
        return ExStream.wrap((Stream)this.stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.stream.close();
    }
}

