/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.dongliu.commons.collection.ExStream;
import net.dongliu.commons.collection.Tuple2;
import net.dongliu.commons.collection.Tuple3;
import net.dongliu.commons.collection.Tuple4;
import net.dongliu.commons.collection.Tuple5;
import net.dongliu.commons.collection.Tuple6;
import net.dongliu.commons.collection.Tuple7;
import net.dongliu.commons.collection.TupleUtils;

public class FutureUtils {
    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static <A, B> CompletableFuture<Tuple2<A, B>> combine(CompletableFuture<A> af, CompletableFuture<B> bf) {
        return af.thenCombine(bf, TupleUtils::of);
    }

    public static <A, B, C> CompletableFuture<Tuple3<A, B, C>> combine(CompletableFuture<A> af, CompletableFuture<B> bf, CompletableFuture<C> cf) {
        return FutureUtils.combine(af, bf).thenCombine(cf, (t2, c) -> new Tuple3(t2._1(), t2._2(), c));
    }

    public static <A, B, C, D> CompletableFuture<Tuple4<A, B, C, D>> combine(CompletableFuture<A> af, CompletableFuture<B> bf, CompletableFuture<C> cf, CompletableFuture<D> df) {
        return FutureUtils.combine(af, bf, cf).thenCombine(df, (t3, d) -> new Tuple4(t3._1(), t3._2(), t3._3(), d));
    }

    public static <A, B, C, D, E> CompletableFuture<Tuple5<A, B, C, D, E>> combine(CompletableFuture<A> af, CompletableFuture<B> bf, CompletableFuture<C> cf, CompletableFuture<D> df, CompletableFuture<E> ef) {
        return FutureUtils.combine(af, bf, cf, df).thenCombine(ef, (t4, e) -> new Tuple5(t4._1(), t4._2(), t4._3(), t4._4(), e));
    }

    public static <A, B, C, D, E, F> CompletableFuture<Tuple6<A, B, C, D, E, F>> combine(CompletableFuture<A> af, CompletableFuture<B> bf, CompletableFuture<C> cf, CompletableFuture<D> df, CompletableFuture<E> ef, CompletableFuture<F> ff) {
        return FutureUtils.combine(af, bf, cf, df, ef).thenCombine(ff, (t, f) -> new Tuple6(t._1(), t._2(), t._3(), t._4(), t._5(), f));
    }

    public static <A, B, C, D, E, F, G> CompletableFuture<Tuple7<A, B, C, D, E, F, G>> combine(CompletableFuture<A> af, CompletableFuture<B> bf, CompletableFuture<C> cf, CompletableFuture<D> df, CompletableFuture<E> ef, CompletableFuture<F> ff, CompletableFuture<G> gf) {
        return FutureUtils.combine(af, bf, cf, df, ef, ff).thenCombine(gf, (t, g) -> new Tuple7(t._1(), t._2(), t._3(), t._4(), t._5(), t._6(), g));
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> combine(CompletableFuture<T> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(e -> ExStream.wrap(futures).map(f -> f.getNow(null)).toList());
    }

    public static <T> CompletableFuture<List<T>> combine(Collection<CompletableFuture<T>> futures) {
        return FutureUtils.combine(futures.toArray(new CompletableFuture[futures.size()]));
    }
}

