/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.http;

import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.util.BitSet;

public class UrlCoder {
    static BitSet queryWhiteSet = UrlCoder.basicSet();
    static BitSet pathSegmentWhiteSet;
    static BitSet fragmentWhiteSet;
    static final int caseDiff = 32;

    private static BitSet basicSet() {
        int i;
        BitSet basicSet = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            basicSet.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            basicSet.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            basicSet.set(i);
        }
        return basicSet;
    }

    public static String encodeQuery(String s, String charset) {
        return UrlCoder.encodeQuery(s, Charset.forName(charset));
    }

    public static String encodeQuery(String s, Charset charset) {
        return UrlCoder._encode(s, charset, queryWhiteSet);
    }

    public static String decodeQuery(String s, String charset) {
        return UrlCoder._decode(s, Charset.forName(charset), true);
    }

    public static String decodeQuery(String s, Charset charset) {
        return UrlCoder._decode(s, charset, true);
    }

    public static String encodePathSegment(String s, String charset) {
        return UrlCoder.encodePathSegment(s, Charset.forName(charset));
    }

    public static String encodePathSegment(String s, Charset charset) {
        return UrlCoder._encode(s, charset, pathSegmentWhiteSet);
    }

    public static String decodePathSegment(String s, String charset) {
        return UrlCoder._decode(s, Charset.forName(charset), false);
    }

    public static String decodePathSegment(String s, Charset charset) {
        return UrlCoder._decode(s, charset, false);
    }

    public static String encodeFragment(String s, String charset) {
        return UrlCoder.encodeFragment(s, Charset.forName(charset));
    }

    public static String encodeFragment(String s, Charset charset) {
        return UrlCoder._encode(s, charset, fragmentWhiteSet);
    }

    public static String decodeFragment(String s, String charset) {
        return UrlCoder._decode(s, Charset.forName(charset), false);
    }

    public static String decodeFragment(String s, Charset charset) {
        return UrlCoder._decode(s, charset, false);
    }

    private static String _encode(String s, Charset charset, BitSet whiteSet) {
        boolean needToChange = false;
        StringBuilder sb = new StringBuilder(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int i = 0;
        while (i < s.length()) {
            byte[] ba;
            char c = s.charAt(i);
            if (whiteSet.get(c)) {
                sb.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !whiteSet.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            for (byte b : ba = str.getBytes(charset)) {
                sb.append('%');
                char ch = Character.forDigit(b >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                sb.append(ch);
                ch = Character.forDigit(b & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                sb.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? sb.toString() : s;
    }

    public static String _decode(String s, Charset charset, boolean isQueryPart) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    if (isQueryPart) {
                        sb.append(' ');
                    } else {
                        sb.append('+');
                    }
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    static {
        for (char c : "-_.*?/".toCharArray()) {
            queryWhiteSet.set(c);
        }
        pathSegmentWhiteSet = UrlCoder.basicSet();
        for (char c : ":@-._~!$&'()*+,;=".toCharArray()) {
            pathSegmentWhiteSet.set(c);
        }
        fragmentWhiteSet = UrlCoder.basicSet();
        for (char c : "/?:@-._~!$&'()*+,;=".toCharArray()) {
            pathSegmentWhiteSet.set(c);
        }
    }
}

