/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import net.dongliu.commons.concurrent.WeakLoader;
import net.dongliu.commons.exception.ReflectException;

public class Enums {
    private static final WeakLoader<Class<? extends Enum>, Object> enumValuesLoader = WeakLoader.create((Function<Class, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, _getValues(java.lang.Class ), (Ljava/lang/Class;)Ljava/lang/Object;)());

    public static <T extends Enum<T>> T[] values(Class<T> cls) {
        return (Enum[])enumValuesLoader.get(cls);
    }

    private static <T extends Enum<T>> T[] _getValues(Class<T> cls) {
        try {
            Method valueMethod = cls.getMethod("values", new Class[0]);
            valueMethod.setAccessible(true);
            Object value = valueMethod.invoke(null, new Object[0]);
            return (Enum[])value;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    public static <T extends Enum<T>> T ofOrdinal(Class<T> cls, int ordinal) {
        Enum[] values = Enums.values(cls);
        return (T)values[ordinal];
    }

    public static <T extends Enum<T>> T add(T value, int amount) {
        int ordinal = value.ordinal() + amount;
        return (T)Enums.ofOrdinal(value.getClass(), ordinal);
    }
}

