/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.dongliu.commons.Exceptions;
import net.dongliu.commons.exception.StringFormatException;

public class StringFormatter {
    private static final int STATE_PLAIN = 0;
    private static final int STATE_HOLDER_BEGIN = 1;
    private static final int STATE_INDEX = 2;
    private static final int STATE_FORMAT_ALIGN = 5;
    private static final int STATE_FORMAT_SIGN = 6;
    private static final int STATE_FORMAT_SHARP = 4;
    private static final int STATE_FORMAT_WIDTH = 10;
    private static final int STATE_FORMAT_SEP = 11;
    private static final int STATE_FORMAT_PRECISION = 12;
    private static final int STATE_FORMAT_TYPE = 7;
    private static final int STATE_EXPECTED_HOLDER_END = 8;
    private static final int STATE_NO_MATCH_END_HOLDER = 9;
    private final String pattern;
    private int state = 0;
    private int seq = 0;
    private int idx = 0;
    private Object currentValue;
    private String currentString;
    private char align;
    private char padChar;
    private int width;
    private int index;
    private boolean sep;
    private int precision;
    private boolean sharp;
    private boolean padZero;
    private char sign;
    private static final double MAX_PERCENT_DOUBLE = 1.7976931348623156E306;
    private static final BigDecimal PERCENT_MULTIPLY = new BigDecimal(100);

    StringFormatter(String pattern) {
        this.pattern = pattern;
    }

    public String format(Object ... values) {
        StringBuilder sb = new StringBuilder(Math.max(16, this.pattern.length() + values.length * 10));
        try {
            this.formatTo(sb, values);
        }
        catch (IOException e) {
            throw Exceptions.uncheck(e);
        }
        return sb.toString();
    }

    public void formatTo(Appendable sb, Object ... values) throws IOException {
        this.reset();
        while (this.idx < this.pattern.length()) {
            char c = this.pattern.charAt(this.idx);
            block0 : switch (this.state) {
                case 0: {
                    switch (c) {
                        case '{': {
                            this.state = 1;
                            break block0;
                        }
                        case '}': {
                            this.state = 9;
                            break block0;
                        }
                    }
                    sb.append(c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case '{': {
                            sb.append('{');
                            this.state = 0;
                            break block0;
                        }
                        case '}': {
                            this.state = 7;
                            this.currentValue = values[this.seq];
                            ++this.seq;
                            --this.idx;
                            break block0;
                        }
                        case ':': {
                            this.currentValue = values[this.seq];
                            ++this.seq;
                            this.state = 5;
                            break block0;
                        }
                    }
                    if (this.isDigit(c)) {
                        this.state = 2;
                        this.index = c - 48;
                        break;
                    }
                    throw new StringFormatException("Pos " + this.idx + " unexpected char " + c);
                }
                case 2: {
                    if (c == '}') {
                        this.currentValue = values[this.index];
                        --this.idx;
                        this.state = 7;
                        break;
                    }
                    if (this.isDigit(c)) {
                        this.index = this.index * 10 + c - 48;
                        break;
                    }
                    if (c != ':') break;
                    this.currentValue = values[this.index];
                    this.state = 5;
                    break;
                }
                case 5: {
                    if (this.isAlign(c)) {
                        this.align = c;
                        this.padChar = (char)32;
                    } else if (this.idx + 1 < this.pattern.length()) {
                        char c2 = this.pattern.charAt(this.idx + 1);
                        if (this.isAlign(c2)) {
                            ++this.idx;
                            this.align = c2;
                            this.padChar = c;
                        } else {
                            --this.idx;
                        }
                    } else {
                        --this.idx;
                    }
                    this.state = 6;
                    break;
                }
                case 6: {
                    switch (c) {
                        case ' ': 
                        case '+': 
                        case '-': {
                            this.sign = c;
                            break;
                        }
                        default: {
                            --this.idx;
                        }
                    }
                    this.state = 4;
                    break;
                }
                case 4: {
                    if (c == '#') {
                        this.sharp = true;
                    } else {
                        --this.idx;
                    }
                    this.state = 10;
                    break;
                }
                case 10: {
                    if (this.isDigit(c)) {
                        if (c == '0') {
                            this.padZero = true;
                        }
                        this.width = this.readInt(c);
                    }
                    --this.idx;
                    this.state = 11;
                    break;
                }
                case 11: {
                    if (c == ',') {
                        this.sep = true;
                    } else {
                        --this.idx;
                    }
                    this.state = 12;
                    break;
                }
                case 12: {
                    if (c == '.') {
                        if (!this.isDigit(c = this.pattern.charAt(++this.idx))) {
                            throw new StringFormatException("Pos " + this.idx + " expect precision value");
                        }
                        this.precision = this.readInt(c);
                    }
                    --this.idx;
                    this.state = 7;
                    break;
                }
                case 7: {
                    this.formatValue(sb, c);
                    this.state = 8;
                    break;
                }
                case 8: {
                    if (c != '}') {
                        throw new StringFormatException("Pos " + this.idx + " expect '}'");
                    }
                    this.state = 0;
                    break;
                }
                case 9: {
                    switch (c) {
                        case '}': {
                            sb.append('}');
                            this.state = 0;
                            break block0;
                        }
                    }
                    throw new StringFormatException("Pos " + this.idx + " unmatched single '}' found");
                }
                default: {
                    throw new StringFormatException("Pos " + this.idx + " unexpected state " + this.state + " encountered");
                }
            }
            ++this.idx;
        }
        if (this.state != 0) {
            throw new StringFormatException("Unfinished place holder");
        }
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private int readInt(char c) {
        int i = c - 48;
        while (this.isDigit(c = this.pattern.charAt(++this.idx))) {
            i = i * 10 + c - 48;
        }
        return i;
    }

    private void formatValue(Appendable sb, char c) throws IOException {
        block52: {
            String leading;
            char signChar;
            block51: {
                char first;
                boolean isFloat = this.isFloat(this.currentValue);
                boolean isInt = this.isInt(this.currentValue);
                boolean isString = this.currentValue instanceof String;
                int type = c;
                switch (c) {
                    case 115: {
                        if (!isString) {
                            throw new StringFormatException("Value at is not string, should use type s");
                        }
                        this.currentString = (String)this.currentValue;
                        break;
                    }
                    case 98: {
                        this.currentString = this.formatRadixNumber(this.currentValue, 2);
                        break;
                    }
                    case 100: {
                        this.currentString = this.formatInt(this.currentValue);
                        break;
                    }
                    case 111: {
                        this.currentString = this.formatRadixNumber(this.currentValue, 8);
                        break;
                    }
                    case 120: {
                        this.currentString = this.formatRadixNumber(this.currentValue, 16);
                        break;
                    }
                    case 88: {
                        this.currentString = this.formatRadixNumber(this.currentValue, 16).toUpperCase();
                        break;
                    }
                    case 110: {
                        throw new UnsupportedOperationException();
                    }
                    case 69: 
                    case 101: {
                        throw new UnsupportedOperationException();
                    }
                    case 70: 
                    case 102: {
                        this.currentString = this.formatFloatNumber(this.currentValue);
                        break;
                    }
                    case 71: 
                    case 103: {
                        throw new UnsupportedOperationException();
                    }
                    case 37: {
                        this.currentString = this.formatPercentageNumber(this.currentValue);
                        break;
                    }
                    case 125: {
                        if (isInt) {
                            type = 100;
                            this.currentString = this.formatInt(this.currentValue);
                        } else if (isFloat) {
                            type = 102;
                            this.currentString = this.formatFloatNumber(this.currentValue);
                        } else {
                            type = 0;
                            this.currentString = String.valueOf(this.currentValue);
                        }
                        --this.idx;
                        break;
                    }
                    default: {
                        throw new StringFormatException("Pos " + this.idx + " unexpected char " + (char)c);
                    }
                }
                signChar = '\u0000';
                if ((isFloat || isInt) && (first = this.currentString.charAt(0)) == '-') {
                    signChar = first;
                    this.currentString = this.currentString.substring(1);
                }
                if (this.sign != '-' && signChar == '\u0000') {
                    signChar = this.sign;
                }
                int nowWidth = this.currentString.length();
                if (signChar != '\u0000') {
                    ++nowWidth;
                }
                leading = null;
                if (this.sharp) {
                    nowWidth += 2;
                    if (type == 98) {
                        leading = "0b";
                    } else if (type == 111) {
                        leading = "0o";
                    } else if (type == 120) {
                        leading = "0x";
                    } else if (type == 88) {
                        leading = "0X";
                    } else {
                        throw new StringFormatException("# only for binary, octal, and hex int values");
                    }
                }
                if (this.padZero) {
                    if (this.align == '\u0000') {
                        this.align = (char)61;
                    }
                    if (this.padChar == '\u0000') {
                        this.padChar = (char)48;
                    }
                }
                if (this.padChar == '\u0000') {
                    this.padChar = (char)32;
                }
                if (this.align == '\u0000' || this.width <= nowWidth) break block51;
                switch (this.align) {
                    case '>': {
                        this.appendPadChar(sb, this.width - nowWidth, this.padChar);
                        if (signChar != '\u0000') {
                            sb.append(signChar);
                        }
                        if (leading != null) {
                            sb.append(leading);
                        }
                        sb.append(this.currentString);
                        break block52;
                    }
                    case '<': {
                        if (signChar != '\u0000') {
                            sb.append(signChar);
                        }
                        if (leading != null) {
                            sb.append(leading);
                        }
                        sb.append(this.currentString);
                        this.appendPadChar(sb, this.width - nowWidth, this.padChar);
                        break block52;
                    }
                    case '^': {
                        int padLeft = (this.width - nowWidth) / 2;
                        int padRight = this.width - nowWidth - padLeft;
                        this.appendPadChar(sb, padLeft, this.padChar);
                        if (signChar != '\u0000') {
                            sb.append(signChar);
                        }
                        if (leading != null) {
                            sb.append(leading);
                        }
                        sb.append(this.currentString);
                        this.appendPadChar(sb, padRight, this.padChar);
                        break block52;
                    }
                    case '=': {
                        if (signChar != '\u0000') {
                            sb.append(signChar);
                        }
                        if (leading != null) {
                            sb.append(leading);
                        }
                        this.appendPadChar(sb, this.width - nowWidth, this.padChar);
                        sb.append(this.currentString);
                        break block52;
                    }
                    default: {
                        throw new RuntimeException("unknown align:" + this.align);
                    }
                }
            }
            if (signChar != '\u0000') {
                sb.append(signChar);
            }
            if (leading != null) {
                sb.append(leading);
            }
            sb.append(this.currentString);
        }
        this.reset();
    }

    private void appendPadChar(Appendable sb, int num, char padChar) throws IOException {
        for (int i = 0; i < num; ++i) {
            sb.append(padChar);
        }
    }

    private void reset() {
        this.currentString = null;
        this.currentValue = null;
        this.align = '\u0000';
        this.width = 0;
        this.sep = false;
        this.sharp = false;
        this.sign = (char)45;
        this.precision = 6;
        this.padZero = false;
        this.index = 0;
        this.padChar = '\u0000';
    }

    private boolean isFloat(Object currentValue) {
        return currentValue instanceof Float || currentValue instanceof Double || currentValue instanceof BigDecimal;
    }

    private boolean isInt(Object currentValue) {
        return currentValue instanceof Integer || currentValue instanceof Long || currentValue instanceof BigInteger;
    }

    private String formatInt(Object currentValue) {
        String format = "%";
        if (this.sep) {
            format = format + ',';
        }
        format = format + 'd';
        return String.format(format, currentValue);
    }

    private String formatFloatNumber(Object currentValue) {
        String format = "%";
        if (this.sep) {
            format = format + ',';
        }
        format = format + "." + this.precision + 'f';
        return String.format(format, currentValue);
    }

    private String formatRadixNumber(Object currentValue, int radix) {
        String s;
        if (currentValue instanceof Integer) {
            s = Integer.toString((Integer)currentValue, radix);
        } else if (currentValue instanceof Long) {
            s = Long.toString((Long)currentValue, radix);
        } else if (currentValue instanceof BigInteger) {
            s = ((BigInteger)currentValue).toString(radix);
        } else {
            throw new StringFormatException("Expect int num");
        }
        return s;
    }

    private String formatPercentageNumber(Object currentValue) {
        if (currentValue instanceof Float) {
            return this.formatFloatNumber(((Float)currentValue).doubleValue() * 100.0) + '%';
        }
        if (currentValue instanceof Double) {
            double v = (Double)currentValue;
            if (v < 1.7976931348623156E306) {
                return this.formatFloatNumber(v * 100.0) + '%';
            }
            return this.formatFloatNumber(new BigDecimal(v).multiply(PERCENT_MULTIPLY)) + '%';
        }
        if (currentValue instanceof BigDecimal) {
            return this.formatFloatNumber(((BigDecimal)currentValue).multiply(PERCENT_MULTIPLY)) + '%';
        }
        throw new StringFormatException("Expect float num");
    }

    private boolean isAlign(char c) {
        return c == '>' || c == '<' || c == '^' || c == '=';
    }
}

