/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import javax.annotation.Nullable;
import net.dongliu.commons.StringFormatter;
import net.dongliu.commons.function.CharPredicate;

public class Strings {
    public static String nullToEmpty(@Nullable String str) {
        return str == null ? "" : str;
    }

    public static String between(String str, String startStr, String endStr) {
        int start = str.indexOf(startStr);
        if (start == -1) {
            return "";
        }
        int end = str.indexOf(endStr, start += startStr.length());
        if (end == -1) {
            return "";
        }
        return str.substring(start, end);
    }

    public static String before(String str, String substr) {
        if (str.isEmpty()) {
            return str;
        }
        int end = str.indexOf(substr);
        if (end < 0) {
            return str;
        }
        return str.substring(0, end);
    }

    public static String after(String str, String substr) {
        if (str.isEmpty()) {
            return str;
        }
        int begin = str.indexOf(substr);
        if (begin < 0) {
            return str;
        }
        return str.substring(begin + substr.length());
    }

    public static String beforeLast(String str, String substr) {
        if (str.isEmpty()) {
            return str;
        }
        int end = str.lastIndexOf(substr);
        if (end < 0) {
            return str;
        }
        return str.substring(0, end);
    }

    public static String afterLast(String str, String substr) {
        if (str.isEmpty()) {
            return str;
        }
        int begin = str.lastIndexOf(substr);
        if (begin < 0) {
            return str;
        }
        return str.substring(begin + substr.length());
    }

    public static String slice(String str, int begin, int end) {
        int len = str.length();
        if (begin < 0) {
            begin += len;
        }
        if (end < 0) {
            end += len;
        }
        return str.substring(begin, end);
    }

    public static String sliceLeft(String str, int len) {
        return str.substring(0, len);
    }

    public static String sliceRight(String str, int len) {
        return str.substring(str.length() - len);
    }

    public static String padLeft(String str, int len, char padding) {
        if (str.length() > len) {
            return str;
        }
        StringBuilder sb = new StringBuilder(len);
        int paddingLen = len - str.length();
        for (int i = 0; i < paddingLen; ++i) {
            sb.append(padding);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padLeft(String str, int len) {
        return Strings.padLeft(str, len, ' ');
    }

    public static String padRight(String str, int len, char padding) {
        if (str.length() > len) {
            return str;
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(str);
        int paddingLen = len - str.length();
        for (int i = 0; i < paddingLen; ++i) {
            sb.append(padding);
        }
        return sb.toString();
    }

    public static String padRight(String str, int len) {
        return Strings.padRight(str, len, ' ');
    }

    public static String padCenter(String str, int len) {
        return Strings.padCenter(str, len, ' ');
    }

    public static String padCenter(String str, int len, char padding) {
        int i;
        if (str.length() > len) {
            return str;
        }
        StringBuilder sb = new StringBuilder(len);
        int paddingLen = len - str.length();
        int left = paddingLen / 2;
        int right = paddingLen - left;
        for (i = 0; i < left; ++i) {
            sb.append(padding);
        }
        sb.append(str);
        for (i = 0; i < right; ++i) {
            sb.append(padding);
        }
        return sb.toString();
    }

    public static String repeat(String str, int count) {
        StringBuilder sb = new StringBuilder(str.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String capitalize(String str) {
        if (str.isEmpty()) {
            return str;
        }
        char c = str.charAt(0);
        if (!Character.isLowerCase(c)) {
            return str;
        }
        return Character.toUpperCase(c) + str.substring(1);
    }

    public static String deCapitalize(String str) {
        if (str.isEmpty()) {
            return str;
        }
        char c = str.charAt(0);
        if (!Character.isUpperCase(c)) {
            return str;
        }
        return Character.toLowerCase(c) + str.substring(1);
    }

    public static String filter(String str, CharPredicate predicate) {
        if (str.isEmpty()) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!predicate.accept(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removePrefix(String str, String prefix) {
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isAsciiLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isIntNumber(String str) {
        if (str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Strings.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        if (str.isEmpty()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Strings.isDigit(c)) continue;
            if (c != '.') {
                return false;
            }
            if (i == 0 || i == str.length() - 1) {
                return false;
            }
            if (++count <= 1) continue;
            return false;
        }
        return true;
    }

    public static String format(String pattern, Object ... values) {
        return new StringFormatter(pattern).format(values);
    }

    public static int toInt(String str) {
        return Strings.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return Strings.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return Strings.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return Strings.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

