/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.dongliu.commons.codec.Hexes;
import net.dongliu.commons.exception.Exceptions;

public class Digests {
    private static final int BUFFER_SIZE = 8192;
    public static final String MD2 = "MD2";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";

    public static Digest create(String algorithm) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.sneakyThrow(e);
        }
        return new Digest(md);
    }

    public static Digest md2() {
        return Digests.create(MD2);
    }

    public static Digest md5() {
        return Digests.create(MD5);
    }

    public static Digest md5(byte[] data) {
        return Digests.create(MD5).update(data);
    }

    public static Digest sha1() {
        return Digests.create(SHA1);
    }

    public static Digest sha1(byte[] data) {
        return Digests.create(SHA1).update(data);
    }

    public static Digest sha256() {
        return Digests.create(SHA256);
    }

    public static Digest sha256(byte[] data) {
        return Digests.create(SHA256).update(data);
    }

    public static Digest sha384() {
        return Digests.create(SHA384);
    }

    public static Digest sha384(byte[] data) {
        return Digests.create(SHA384).update(data);
    }

    public static Digest sha512() {
        return Digests.create(SHA512);
    }

    public static Digest sha512(byte[] data) {
        return Digests.create(SHA512).update(data);
    }

    public static class Digest {
        private final MessageDigest md;

        private Digest(MessageDigest md) {
            this.md = md;
        }

        public Digest update(byte[] data) {
            this.md.update(data);
            return this;
        }

        public Digest update(byte[] data, int offset, int len) {
            this.md.update(data, offset, len);
            return this;
        }

        public Digest update(ByteBuffer buffer) {
            this.md.update(buffer);
            return this;
        }

        public Digest update(CharBuffer buffer, Charset charset) {
            int len = buffer.remaining();
            int chunkSize = 1024;
            for (int offset = 0; offset < len; offset += chunkSize) {
                CharBuffer subBuffer = buffer.subSequence(offset, Math.min(offset + chunkSize, len));
                ByteBuffer byteBuffer = charset.encode(subBuffer);
                this.md.update(byteBuffer);
            }
            return this;
        }

        public Digest update(CharBuffer buffer) {
            return this.update(buffer, StandardCharsets.UTF_8);
        }

        public Digest update(CharSequence charSequence, Charset charset) {
            CharBuffer buffer = CharBuffer.wrap(charSequence);
            return this.update(buffer, charset);
        }

        public Digest update(CharSequence charSequence) {
            return this.update(charSequence, StandardCharsets.UTF_8);
        }

        public Digest update(InputStream in) {
            try (InputStream input = in;){
                int count;
                byte[] buffer = new byte[8192];
                while ((count = input.read(buffer)) != -1) {
                    this.md.update(buffer, 0, count);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return this;
        }

        public byte[] toByteArray() {
            return this.md.digest();
        }

        public String toHexUpper() {
            return Hexes.hexUpper(this.toByteArray());
        }

        public String toHexLower() {
            return Hexes.hexLower(this.toByteArray());
        }
    }
}

