/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dongliu.commons.collection.Pair;

public class Lists {
    public static <T> List<T> nullToEmpty(@Nullable List<T> list) {
        return list == null ? Lists.of() : list;
    }

    public static <T, R> List<R> convert(Collection<T> list, Function<? super T, ? extends R> function) {
        return Lists.convert(() -> new ArrayList(list.size()), list, function);
    }

    public static <T, R, E extends List<R>> E convert(Supplier<E> supplier, Collection<T> list, Function<? super T, ? extends R> function) {
        List newList = (List)supplier.get();
        for (T value : list) {
            newList.add(function.apply(value));
        }
        return (E)newList;
    }

    public static <T> List<T> filter(List<T> list, Predicate<? super T> predicate) {
        ArrayList<T> newList = new ArrayList<T>(Math.min(16, list.size()));
        for (T value : list) {
            if (!predicate.test(value)) continue;
            newList.add(value);
        }
        return newList;
    }

    public static <T, K, V> Map<K, V> toMap(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (T value : list) {
            map.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return map;
    }

    public static <T, K> Map<K, T> toMap(List<T> list, Function<? super T, ? extends K> keyMapper) {
        HashMap<K, T> map = new HashMap<K, T>();
        for (T value : list) {
            map.put(keyMapper.apply(value), value);
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(List<? extends Map.Entry<K, V>> entries) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <T> List<T> wrapImmutable(List<T> list) {
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> copyImmutable(Collection<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> List<T> create() {
        return new ArrayList();
    }

    public static <T> List<T> create(T value) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(value);
        return list;
    }

    public static <T> List<T> create(T value1, T value2) {
        ArrayList<T> list = new ArrayList<T>(2);
        list.add(value1);
        list.add(value2);
        return list;
    }

    public static <T> List<T> create(T value1, T value2, T value3) {
        ArrayList<T> list = new ArrayList<T>(3);
        list.add(value1);
        list.add(value2);
        list.add(value3);
        return list;
    }

    public static <T> List<T> create(T value1, T value2, T value3, T value4) {
        ArrayList<T> list = new ArrayList<T>(4);
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        return list;
    }

    public static <T> List<T> create(T value1, T value2, T value3, T value4, T value5) {
        ArrayList<T> list = new ArrayList<T>(5);
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        return list;
    }

    public static <T> List<T> create(T value1, T value2, T value3, T value4, T value5, T value6) {
        ArrayList<T> list = new ArrayList<T>(6);
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        return list;
    }

    public static <T> List<T> create(T value1, T value2, T value3, T value4, T value5, T value6, T value7) {
        ArrayList<T> list = new ArrayList<T>(7);
        list.add(value1);
        list.add(value2);
        list.add(value3);
        list.add(value4);
        list.add(value5);
        list.add(value6);
        list.add(value7);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> create(T ... values) {
        ArrayList list = new ArrayList(values.length);
        Collections.addAll(list, values);
        return list;
    }

    public static <T> List<T> of() {
        return Collections.emptyList();
    }

    public static <T> List<T> of(T value) {
        return Collections.singletonList(value);
    }

    @SafeVarargs
    public static <T> List<T> of(T ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public static <K, V> List<Pair<K, V>> zip(List<? extends K> list1, List<? extends V> list2) {
        if (list1.size() != list2.size()) {
            throw new IllegalArgumentException("Size must be the same");
        }
        ArrayList<Pair<K, V>> list = new ArrayList<Pair<K, V>>(list1.size());
        Iterator<K> keyIter = list1.iterator();
        Iterator<V> valueIter = list2.iterator();
        while (keyIter.hasNext() && valueIter.hasNext()) {
            list.add(Pair.of(keyIter.next(), valueIter.next()));
        }
        return list;
    }

    public static <T> List<List<T>> split(List<T> list, int subSize) {
        int len = list.size();
        int count = (len - 1) / subSize + 1;
        ArrayList<List<T>> result = new ArrayList<List<T>>(count);
        for (int i = 0; i < count; ++i) {
            int start = i * subSize;
            List<T> subList = list.subList(start, Math.min(start + subSize, len));
            result.add(subList);
        }
        return result;
    }

    public static <T> List<T> concat(List<? extends T> list1, List<? extends T> list2) {
        ArrayList<T> list = new ArrayList<T>(list1.size() + list2.size());
        list.addAll(list1);
        list.addAll(list2);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> concat(List<? extends T> ... lists) {
        return Lists.concat(Lists.of(lists));
    }

    public static <T> List<T> concat(Collection<? extends List<? extends T>> lists) {
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        ArrayList<T> newList = new ArrayList<T>(size);
        for (List<T> list : lists) {
            newList.addAll(list);
        }
        return newList;
    }

    public static <T> Optional<T> findFirst(List<T> values, Predicate<T> predicate) {
        for (T value : values) {
            if (!predicate.test(value)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

