/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Maps {
    public static <K, V> Map<K, V> nullToEmpty(@Nullable Map<K, V> map) {
        return map == null ? Maps.of() : map;
    }

    public static <K, V> Map<K, V> wrapImmutable(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> copyImmutable(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    public static <K, V, U> Map<K, U> convert(Map<K, V> map, Function<? super V, ? extends U> function) {
        Map newMap = Maps.create();
        map.forEach((k, v) -> newMap.put(k, function.apply((Object)v)));
        return newMap;
    }

    public static <K, V> Map<K, V> of() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> value) {
        return Maps.wrapImmutable(Maps.create(value));
    }

    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> value1, Map.Entry<? extends K, ? extends V> value2) {
        return Maps.wrapImmutable(Maps.create(value1, value2));
    }

    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> value1, Map.Entry<? extends K, ? extends V> value2, Map.Entry<? extends K, ? extends V> value3) {
        return Maps.wrapImmutable(Maps.create(value1, value2, value3));
    }

    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> value1, Map.Entry<? extends K, ? extends V> value2, Map.Entry<? extends K, ? extends V> value3, Map.Entry<? extends K, ? extends V> value4) {
        return Maps.wrapImmutable(Maps.create(value1, value2, value3, value4));
    }

    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> value1, Map.Entry<? extends K, ? extends V> value2, Map.Entry<? extends K, ? extends V> value3, Map.Entry<? extends K, ? extends V> value4, Map.Entry<? extends K, ? extends V> value5) {
        return Maps.wrapImmutable(Maps.create(value1, value2, value3, value4, value5));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> ... values) {
        if (values.length == 0) {
            return Maps.of();
        }
        return Maps.wrapImmutable(Maps.create(values));
    }

    public static <K, V> Map<K, V> of(Collection<? extends Map.Entry<K, V>> values) {
        return Maps.wrapImmutable(Maps.create(values));
    }

    public static <K, V> Map<K, V> create() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> create(Map.Entry<? extends K, ? extends V> value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(value.getKey(), value.getValue());
        return map;
    }

    public static <K, V> Map<K, V> create(Map.Entry<? extends K, ? extends V> value1, Map.Entry<? extends K, ? extends V> value2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(value1.getKey(), value1.getValue());
        map.put(value2.getKey(), value2.getValue());
        return map;
    }

    public static <K, V> Map<K, V> create(Map.Entry<? extends K, ? extends V> value1, Map.Entry<? extends K, ? extends V> value2, Map.Entry<? extends K, ? extends V> value3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(value1.getKey(), value1.getValue());
        map.put(value2.getKey(), value2.getValue());
        map.put(value3.getKey(), value3.getValue());
        return map;
    }

    public static <K, V> Map<K, V> create(Map.Entry<? extends K, ? extends V> value1, Map.Entry<? extends K, ? extends V> value2, Map.Entry<? extends K, ? extends V> value3, Map.Entry<? extends K, ? extends V> value4) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(value1.getKey(), value1.getValue());
        map.put(value2.getKey(), value2.getValue());
        map.put(value3.getKey(), value3.getValue());
        map.put(value4.getKey(), value4.getValue());
        return map;
    }

    public static <K, V> Map<K, V> create(Map.Entry<? extends K, ? extends V> value1, Map.Entry<? extends K, ? extends V> value2, Map.Entry<? extends K, ? extends V> value3, Map.Entry<? extends K, ? extends V> value4, Map.Entry<? extends K, ? extends V> value5) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(value1.getKey(), value1.getValue());
        map.put(value2.getKey(), value2.getValue());
        map.put(value3.getKey(), value3.getValue());
        map.put(value4.getKey(), value4.getValue());
        map.put(value5.getKey(), value5.getValue());
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> create(Map.Entry<? extends K, ? extends V> ... values) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : values) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> create(Collection<? extends Map.Entry<K, V>> values) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> tuple : values) {
            map.put(tuple.getKey(), tuple.getValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> zip(List<K> keys, List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("Key and value size not equals");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        Iterator<K> keyIter = keys.iterator();
        Iterator<V> valueIter = values.iterator();
        while (keyIter.hasNext() && valueIter.hasNext()) {
            map.put(keyIter.next(), valueIter.next());
        }
        return map;
    }
}

