/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

public class Pair<A, B>
implements Map.Entry<A, B>,
Serializable {
    private static final long serialVersionUID = -6525353427059094141L;
    private final A first;
    private final B second;

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    @Override
    public A getKey() {
        return this.first;
    }

    public Pair<A, B> withKey(A newKey) {
        return new Pair<A, B>(newKey, this.second);
    }

    public A getName() {
        return this.first;
    }

    public Pair<A, B> withName(A newKey) {
        return new Pair<A, B>(newKey, this.second);
    }

    @Override
    public B getValue() {
        return this.second;
    }

    @Override
    public B setValue(B value) {
        throw new UnsupportedOperationException("Pair is read only");
    }

    public Pair<A, B> withValue(B newValue) {
        return new Pair<A, B>(this.first, newValue);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.first != null ? !this.first.equals(pair.first) : pair.first != null) {
            return false;
        }
        return !(this.second == null ? pair.second != null : !this.second.equals(pair.second));
    }

    @Override
    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + ")";
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<K, V>(key, value);
    }
}

