/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.dongliu.commons.Enums;
import net.dongliu.commons.collection.EmptyRange;
import net.dongliu.commons.collection.RangeImpl;

public interface Range<T>
extends Iterable<T> {
    public static <T> Range<T> of(T start, T end, int step, boolean endClose, Adder<T> adder, Subtractor<T> subtractor) {
        return new RangeImpl<T>(start, end, step, endClose, adder, subtractor);
    }

    public static Range<LocalDate> until(LocalDate start, LocalDate end) {
        return Range.of(start, end, 1, false, LocalDate::plusDays, (v1, v2) -> ChronoUnit.DAYS.between((Temporal)v2, (Temporal)v1));
    }

    public static Range<YearMonth> until(YearMonth start, YearMonth end) {
        return Range.of(start, end, 1, false, YearMonth::plusMonths, (v1, v2) -> ChronoUnit.MONTHS.between((Temporal)v2, (Temporal)v1));
    }

    public static Range<Year> until(Year start, Year end) {
        return Range.of(start, end, 1, false, Year::plusYears, (v1, v2) -> ChronoUnit.YEARS.between((Temporal)v2, (Temporal)v1));
    }

    public static Range<Integer> until(int start, int end) {
        return Range.of(start, end, 1, false, (v, amount) -> Math.addExact(v, Math.toIntExact(amount)), (v1, v2) -> v1 - v2);
    }

    public static Range<Long> until(long start, long end) {
        return Range.of(start, end, 1, false, Math::addExact, (v1, v2) -> v1 - v2);
    }

    public static <T extends Enum<T>> Range<T> until(T start, T end) {
        return Range.of(start, end, 1, false, (v, amount) -> Enums.add(v, Math.toIntExact(amount)), (v1, v2) -> v1.ordinal() - v2.ordinal());
    }

    public static Range<LocalDate> to(LocalDate start, LocalDate end) {
        return Range.of(start, end, 1, true, LocalDate::plusDays, (v1, v2) -> ChronoUnit.DAYS.between((Temporal)v2, (Temporal)v1));
    }

    public static Range<YearMonth> to(YearMonth start, YearMonth end) {
        return Range.of(start, end, 1, true, YearMonth::plusMonths, (v1, v2) -> ChronoUnit.MONTHS.between((Temporal)v2, (Temporal)v1));
    }

    public static Range<Year> to(Year start, Year end) {
        return Range.of(start, end, 1, true, Year::plusYears, (v1, v2) -> ChronoUnit.YEARS.between((Temporal)v2, (Temporal)v1));
    }

    public static Range<Integer> to(int start, int end) {
        return Range.of(start, end, 1, true, (v, amount) -> Math.addExact(v, Math.toIntExact(amount)), (v1, v2) -> v1 - v2);
    }

    public static Range<Long> to(long start, long end) {
        return Range.of(start, end, 1, true, Math::addExact, (v1, v2) -> v1 - v2);
    }

    public static <T extends Enum<T>> Range<T> to(T start, T end) {
        return Range.of(start, end, 1, true, (v, amount) -> Enums.add(v, Math.toIntExact(amount)), (v1, v2) -> v1.ordinal() - v2.ordinal());
    }

    public static <T> Range<T> empty() {
        return EmptyRange.instance;
    }

    public Range<T> reverse();

    public Range<T> endClosed(boolean var1);

    public Range<T> step(int var1);

    public boolean contains(T var1);

    public long count();

    public List<T> toList();

    public Stream<T> stream();

    @Override
    public Iterator<T> iterator();

    public static interface Subtractor<T> {
        public long subtract(T var1, T var2);
    }

    public static interface Adder<T> {
        public T add(T var1, long var2);
    }
}

