/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.dongliu.commons.Predicates;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.collection.Range;

@Immutable
class RangeImpl<T>
implements Range<T> {
    private final T start;
    private final T end;
    private final int step;
    private final boolean endClosed;
    private final long count;
    private final Range.Adder<T> adder;
    private final Range.Subtractor<T> subtractor;

    RangeImpl(T start, T end, int step, boolean endClosed, Range.Adder<T> adder, Range.Subtractor<T> subtractor) {
        Predicates.checkArguments(step == 0, "step cannot be 0");
        this.start = Objects.requireNonNull(start);
        this.end = Objects.requireNonNull(end);
        this.step = step;
        this.endClosed = endClosed;
        this.adder = Objects.requireNonNull(adder);
        this.subtractor = Objects.requireNonNull(subtractor);
        this.count = this.calculateCount();
    }

    private long calculateCount() {
        long slots = this.subtractor.subtract(this.end, this.start);
        long num = slots / (long)this.step;
        if (num < 0L) {
            return 0L;
        }
        long reminder = slots % (long)this.step;
        if (reminder == 0L && this.endClosed || reminder != 0L) {
            ++num;
        }
        return num;
    }

    @Override
    public Range<T> reverse() {
        return new RangeImpl<T>(this.end, this.start, -this.step, this.endClosed, this.adder, this.subtractor);
    }

    @Override
    public Range<T> endClosed(boolean endClosed) {
        if (endClosed == this.endClosed) {
            return this;
        }
        return new RangeImpl<T>(this.start, this.end, this.step, endClosed, this.adder, this.subtractor);
    }

    @Override
    public Range<T> step(int step) {
        if (step == this.step) {
            return this;
        }
        return new RangeImpl<T>(this.start, this.end, step, this.endClosed, this.adder, this.subtractor);
    }

    @Override
    public boolean contains(T value) {
        long toStart = this.subtractor.subtract(value, this.start);
        long toEnd = this.subtractor.subtract(value, this.end);
        if (this.step > 0) {
            return toStart >= 0L && (toEnd < 0L || toEnd == 0L && this.endClosed);
        }
        return toStart <= 0L && (toEnd > 0L || toEnd == 0L && this.endClosed);
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public List<T> toList() {
        long count = this.count();
        if (count == 0L) {
            return Lists.of();
        }
        if (count == 1L) {
            return Lists.of(this.start);
        }
        int size = Math.toIntExact(count);
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.adder.add(this.start, i * this.step));
        }
        return list;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<T> iterator() {
        return new RangeIterator(this);
    }

    private static class RangeIterator<T>
    implements Iterator<T> {
        private final RangeImpl<T> range;
        private long seq;

        private RangeIterator(RangeImpl<T> range) {
            this.range = range;
        }

        @Override
        public boolean hasNext() {
            return this.seq < ((RangeImpl)this.range).count;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (T)((RangeImpl)this.range).adder.add(((RangeImpl)this.range).start, (long)((RangeImpl)this.range).step * this.seq++);
        }
    }
}

