/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RawValue {
    private static final RawValue nil = new RawValue(null);
    @Nullable
    private final Object value;

    private RawValue(@Nullable Object value) {
        this.value = value;
    }

    @Nonnull
    public static RawValue of(Object value) {
        return new RawValue(Objects.requireNonNull(value));
    }

    @Nonnull
    public RawValue get(int index) {
        if (this.value == null) {
            return nil;
        }
        if (this.value instanceof List) {
            return new RawValue(((List)this.value).get(index));
        }
        if (this.value.getClass().isArray()) {
            return new RawValue(Array.get(this.value, index));
        }
        throw new UnsupportedOperationException("Type " + this.value.getClass() + " cannot get by index");
    }

    @Nonnull
    public RawValue get(String key) {
        if (this.value == null) {
            return nil;
        }
        if (this.value instanceof Map) {
            return new RawValue(((Map)this.value).get(key));
        }
        throw new UnsupportedOperationException("Type " + this.value.getClass() + " cannot get by index");
    }

    @Nullable
    public <T> T value() {
        return (T)this.value;
    }

    @Nonnull
    public <T> T orElse(T defaultValue) {
        Objects.requireNonNull(defaultValue);
        if (this.value != null) {
            return (T)this.value;
        }
        return defaultValue;
    }

    public boolean present() {
        return this.value != null;
    }
}

