/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Sets {
    public static <T> Set<T> nullToEmpty(@Nullable Set<T> set) {
        return set == null ? Sets.of() : set;
    }

    public static <T> Set<T> wrapImmutable(Set<T> set) {
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> copyImmutable(Collection<T> set) {
        return Collections.unmodifiableSet(new HashSet<T>(set));
    }

    public static <T, R, E extends Set<R>> E convert(Supplier<E> supplier, Collection<T> set, Function<? super T, ? extends R> mapper) {
        Set newSet = (Set)supplier.get();
        for (T item : set) {
            newSet.add(mapper.apply(item));
        }
        return (E)newSet;
    }

    public static <T, R> Set<R> convert(Collection<T> set, Function<? super T, ? extends R> mapper) {
        return Sets.convert(() -> new HashSet((int)((float)set.size() / 0.75f) + 1, 0.75f), set, mapper);
    }

    public static <T> Set<T> filter(Set<T> set, Predicate<? super T> predicate) {
        return Sets.filter(() -> new HashSet((int)((float)set.size() / 0.75f) + 1, 0.75f), set, predicate);
    }

    public static <T, E extends Set<T>> E filter(Supplier<E> supplier, Set<T> set, Predicate<? super T> predicate) {
        Set newSet = (Set)supplier.get();
        for (T value : set) {
            if (!predicate.test(value)) continue;
            newSet.add(value);
        }
        return (E)newSet;
    }

    public static <T> Set<T> create() {
        return new HashSet();
    }

    public static <T> Set<T> create(T value) {
        HashSet<T> set = new HashSet<T>();
        set.add(value);
        return set;
    }

    public static <T> Set<T> create(T value1, T value2) {
        HashSet<T> set = new HashSet<T>();
        set.add(value1);
        set.add(value2);
        return set;
    }

    public static <T> Set<T> create(T value1, T value2, T value3) {
        HashSet<T> set = new HashSet<T>();
        set.add(value1);
        set.add(value2);
        set.add(value3);
        return set;
    }

    public static <T> Set<T> create(T value1, T value2, T value3, T value4) {
        HashSet<T> set = new HashSet<T>();
        set.add(value1);
        set.add(value2);
        set.add(value3);
        set.add(value4);
        return set;
    }

    public static <T> Set<T> create(T value1, T value2, T value3, T value4, T value5) {
        HashSet<T> set = new HashSet<T>();
        set.add(value1);
        set.add(value2);
        set.add(value3);
        set.add(value4);
        set.add(value5);
        return set;
    }

    public static <T> Set<T> create(T value1, T value2, T value3, T value4, T value5, T value6) {
        HashSet<T> set = new HashSet<T>();
        set.add(value1);
        set.add(value2);
        set.add(value3);
        set.add(value4);
        set.add(value5);
        set.add(value6);
        return set;
    }

    public static <T> Set<T> create(T value1, T value2, T value3, T value4, T value5, T value6, T value7) {
        HashSet<T> set = new HashSet<T>();
        set.add(value1);
        set.add(value2);
        set.add(value3);
        set.add(value4);
        set.add(value5);
        set.add(value6);
        set.add(value7);
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> create(T ... values) {
        HashSet set = new HashSet();
        Collections.addAll(set, values);
        return set;
    }

    public static <T> Set<T> of() {
        return Collections.emptySet();
    }

    public static <T> Set<T> of(T value) {
        return Collections.singleton(value);
    }

    public static <T> Set<T> of(T value1, T value2) {
        return Sets.wrapImmutable(Sets.create(value1, value2));
    }

    public static <T> Set<T> of(T value1, T value2, T value3) {
        return Sets.wrapImmutable(Sets.create(value1, value2, value3));
    }

    public static <T> Set<T> of(T value1, T value2, T value3, T value4) {
        return Sets.wrapImmutable(Sets.create(value1, value2, value3, value4));
    }

    public static <T> Set<T> of(T value1, T value2, T value3, T value4, T value5) {
        return Sets.wrapImmutable(Sets.create(value1, value2, value3, value4, value5));
    }

    public static <T> Set<T> of(T value1, T value2, T value3, T value4, T value5, T value6) {
        return Sets.wrapImmutable(Sets.create(value1, value2, value3, value4, value5, value6));
    }

    public static <T> Set<T> of(T value1, T value2, T value3, T value4, T value5, T value6, T value7) {
        return Sets.wrapImmutable(Sets.create(value1, value2, value3, value4, value5, value6, value7));
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... values) {
        return Sets.wrapImmutable(Sets.create(values));
    }
}

