/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.io.Serializable;
import java.util.StringJoiner;
import javax.annotation.Nullable;

public class Triple<A, B, C>
implements Serializable {
    private static final long serialVersionUID = 7698985848288461531L;
    private final A first;
    private final B second;
    private final C third;

    public Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, B, C> Triple<A, B, C> of(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public C third() {
        return this.third;
    }

    public Triple<A, B, C> withFirst(A a) {
        return new Triple<A, B, C>(a, this.second, this.third);
    }

    public Triple<A, B, C> withSecond(B b) {
        return new Triple<A, B, C>(this.first, b, this.third);
    }

    public Triple<A, B, C> withThird(C c) {
        return new Triple<A, B, C>(this.first, this.second, c);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        if (this.first != null ? !this.first.equals(triple.first) : triple.first != null) {
            return false;
        }
        if (this.second != null ? !this.second.equals(triple.second) : triple.second != null) {
            return false;
        }
        return !(this.third == null ? triple.third != null : !this.third.equals(triple.third));
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        result = 31 * result + (this.third != null ? this.third.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", "(", ")").add(String.valueOf(this.first)).add(String.valueOf(this.second)).add(String.valueOf(this.third)).toString();
    }
}

