/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dongliu.commons.Predicates;

public class CountableExecutorService
implements ExecutorService {
    private final ExecutorService executorService;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private int taskNum = 0;

    public CountableExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public int getTaskNum() {
        this.lock.lock();
        try {
            int n = this.taskNum;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean idle() {
        this.lock.lock();
        try {
            boolean bl = this.taskNum == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitTillIdle() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.taskNum > 0) {
                this.condition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillIdle(long time, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        long nanos = timeUnit.toNanos(time);
        this.lock.lock();
        try {
            while (this.taskNum > 0) {
                if ((nanos = this.condition.awaitNanos(nanos)) > 0L) continue;
                throw new TimeoutException();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(Callable<T> task) {
        this.increaseCount();
        return this.executorService.submit(() -> this.callAndArrive(task));
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(Runnable task, T result) {
        this.increaseCount();
        return this.executorService.submit(() -> this.runAndArrive(task), result);
    }

    @Override
    @Nonnull
    public Future<?> submit(Runnable task) {
        this.increaseCount();
        return this.executorService.submit(() -> this.runAndArrive(task));
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Predicates.valuesNotNull(tasks);
        tasks = tasks.stream().map(task -> () -> this.callAndArrive((Callable)task)).collect(Collectors.toList());
        this.increaseCount(tasks.size());
        return this.executorService.invokeAll(tasks);
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Predicates.valuesNotNull(tasks);
        tasks = tasks.stream().map(task -> () -> this.callAndArrive((Callable)task)).collect(Collectors.toList());
        this.increaseCount(tasks.size());
        return this.executorService.invokeAll(tasks, timeout, unit);
    }

    @Override
    @Nonnull
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Predicates.valuesNotNull(tasks);
        tasks = tasks.stream().map(task -> () -> this.callAndArrive((Callable)task)).collect(Collectors.toList());
        this.increaseCount(tasks.size());
        return this.executorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Predicates.valuesNotNull(tasks);
        tasks = tasks.stream().map(task -> () -> this.callAndArrive((Callable)task)).collect(Collectors.toList());
        this.increaseCount(tasks.size());
        return this.executorService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.increaseCount();
        this.executorService.execute(() -> this.runAndArrive(command));
    }

    private <T> T callAndArrive(Callable<T> task) throws Exception {
        try {
            T t = task.call();
            return t;
        }
        finally {
            this.decreaseCountAndNotify();
        }
    }

    private void runAndArrive(Runnable task) {
        try {
            task.run();
        }
        finally {
            this.decreaseCountAndNotify();
        }
    }

    private void increaseCount() {
        this.increaseCount(1);
    }

    private void increaseCount(int num) {
        this.lock.lock();
        try {
            this.taskNum += num;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void decreaseCountAndNotify() {
        this.lock.lock();
        try {
            if (--this.taskNum == 0) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

