/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.util.function.Function;
import java.util.function.Supplier;
import net.dongliu.commons.Exceptions;

public class Lazy<T>
implements Supplier<T> {
    private volatile boolean initialized;
    private volatile T value;
    private volatile Throwable throwable;
    private final Supplier<T> supplier;

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> Lazy<T> create(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (!this.initialized) {
                    try {
                        this.value = this.supplier.get();
                    }
                    catch (Throwable e) {
                        this.throwable = e;
                    }
                    finally {
                        this.initialized = true;
                    }
                }
            }
        }
        if (this.throwable != null) {
            throw Exceptions.sneakyThrow(this.throwable);
        }
        return this.value;
    }

    public <R> Lazy<R> apply(Function<T, R> f) {
        return Lazy.create(() -> f.apply(this.get()));
    }
}

