/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WeakLoader<K, V> {
    private final Map<K, V> preDefs;
    private final WeakHashMap<K, V> weakMap;
    private final ReadWriteLock lock;
    private final Function<K, V> function;

    private WeakLoader(Map<K, V> preDefs, Function<K, V> function) {
        this.preDefs = preDefs;
        this.function = function;
        this.weakMap = new WeakHashMap();
        this.lock = new ReentrantReadWriteLock();
    }

    public static <K, V> WeakLoader<K, V> create(Function<K, V> function) {
        return new WeakLoader(Collections.emptyMap(), function);
    }

    public static <K, V> WeakLoader<K, V> create(Map<K, V> preDefs, Function<K, V> function) {
        return new WeakLoader<K, V>(preDefs, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Objects.requireNonNull(key);
        V value = this.preDefs.get(key);
        if (value != null) {
            return value;
        }
        this.lock.readLock().lock();
        try {
            value = this.weakMap.get(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (value != null) {
            return value;
        }
        this.lock.writeLock().lock();
        try {
            value = this.weakMap.get(key);
            if (value != null) {
                V v = value;
                return v;
            }
            value = this.function.apply(key);
            Objects.requireNonNull(value);
            this.weakMap.put(key, value);
            V v = value;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

