/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.function;

import java.util.Objects;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import net.dongliu.commons.Exceptions;
import net.dongliu.commons.Predicates;

public class Retries {
    private final int maxRetries;
    private static final IntUnaryOperator noInterval = it -> 0;
    private IntUnaryOperator intervalSupplier = noInterval;
    private boolean treatNullAsFailed;

    private Retries(int maxRetries) {
        Predicates.checkArguments(maxRetries < 0, "maxRetries must be larger than 0");
        this.maxRetries = maxRetries;
    }

    public static Retries maxRetries(int count) {
        return new Retries(count);
    }

    public Retries interval(int millis) {
        Predicates.checkArguments(millis < 0, "Interval must be larger than or equal 0");
        return this.interval(it -> millis);
    }

    public Retries interval(IntUnaryOperator intervalSupplier) {
        this.intervalSupplier = Objects.requireNonNull(intervalSupplier);
        return this;
    }

    public Retries treatNullAsFailed() {
        this.treatNullAsFailed = true;
        return this;
    }

    public <T> T run(Supplier<T> supplier) {
        int retryCount = 0;
        Throwable throwable = null;
        while (retryCount < this.maxRetries) {
            if (retryCount > 0) {
                int interval = this.intervalSupplier.applyAsInt(retryCount);
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            try {
                T value = supplier.get();
                if (this.treatNullAsFailed && value == null) {
                    ++retryCount;
                    continue;
                }
                return value;
            }
            catch (Throwable t) {
                throwable = t;
                ++retryCount;
            }
        }
        if (throwable != null) {
            throw Exceptions.sneakyThrow(throwable);
        }
        return null;
    }
}

